/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.item.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;

@Name(value="Item - Rarity")
@Description(value={"Returns the rarity of an item.\nCan be set.\n\nBefore Lusk 1.2 (and Minecraft 1.20.5), this expression returned strings and also worked for enchantments, due to some major changes enchantments no longer have a rarity."})
@Examples(value={"broadcast item rarity of tool", "set item rarity of {_sword} to epic"})
@Since(value={"1.0.0, 1.2 (ItemRarity)"})
@RequiredPlugins(value={"1.20.5"})
public class ExprRarity
extends SimplePropertyExpression<ItemType, ItemRarity> {
    @Nullable
    public ItemRarity convert(ItemType from) {
        ItemMeta itemMeta = from.getItemMeta();
        if (itemMeta.hasRarity()) {
            return itemMeta.getRarity();
        }
        return null;
    }

    protected String getPropertyName() {
        return "item rarity";
    }

    public Class<? extends ItemRarity> getReturnType() {
        return ItemRarity.class;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class[] classArray;
        if (mode == Changer.ChangeMode.SET) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = ItemRarity.class;
        } else {
            classArray = null;
        }
        return classArray;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        ItemType[] itemTypeArray;
        if (mode == Changer.ChangeMode.SET && delta != null && (itemTypeArray = delta[0]) instanceof ItemRarity) {
            ItemRarity itemRarity = (ItemRarity)itemTypeArray;
            for (ItemType itemType : (ItemType[])this.getExpr().getArray(event)) {
                ItemMeta itemMeta = itemType.getItemMeta();
                itemMeta.setRarity(itemRarity);
                itemType.setItemMeta(itemMeta);
            }
        }
    }

    static {
        if (Constants.SPIGOT_HAS_ITEM_RARITY) {
            ExprRarity.register(ExprRarity.class, ItemRarity.class, (String)"item rarity", (String)"itemtypes");
        }
    }
}

