/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.item.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.SkriptColor;
import it.jakegblp.lusk.utils.Constants;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Color;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Item Rarity - Color")
@Description(value={"Returns the color of an item's rarity.\nCan be used with the item itself and it will get its rarity's color without getting the rarity itself if you don't need it."})
@Examples(value={"broadcast rarity color of tool", "broadcast rarity color of item rarity of heart of the sea"})
@Since(value={"1.0.0, 1.2 (ItemRarity)"})
@RequiredPlugins(value={"1.20.5"})
public class ExprRarityColor
extends SimplePropertyExpression<Object, SkriptColor> {
    @Nullable
    public SkriptColor convert(Object from) {
        if (from instanceof ItemType) {
            ItemType itemType = (ItemType)from;
            ItemMeta meta = itemType.getItemMeta();
            if (meta.hasRarity()) {
                from = meta.getRarity();
            } else {
                return null;
            }
        }
        if (from instanceof ItemRarity) {
            ItemRarity itemRarity = (ItemRarity)from;
            TextColor textColor = itemRarity.color();
            return SkriptColor.fromBukkitColor((Color)Color.fromRGB((int)textColor.red(), (int)textColor.green(), (int)textColor.blue()));
        }
        return null;
    }

    @NotNull
    protected String getPropertyName() {
        return "rarity color";
    }

    @NotNull
    public Class<? extends SkriptColor> getReturnType() {
        return SkriptColor.class;
    }

    static {
        if (Constants.SPIGOT_HAS_ITEM_RARITY) {
            ExprRarityColor.register(ExprRarityColor.class, SkriptColor.class, (String)"rarity color", (String)"itemrarities/itemtypes");
        }
    }
}

