/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.item.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.EnchantmentType;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import it.jakegblp.lusk.api.skript.PropertyExpression;
import it.jakegblp.lusk.utils.ItemUtils;
import java.util.Arrays;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Enchanted Book - Stored Enchantments")
@Description(value={"Returns the Enchantments stored in an enchanted book.\nCan be set, added to, removed from, reset and deleted."})
@Examples(value={"broadcast stored enchantments of tool"})
@Since(value={"1.3"})
public class ExprStoredEnchantments
extends PropertyExpression<ItemType, EnchantmentType> {
    protected EnchantmentType[] get(Event event, ItemType[] source) {
        return (EnchantmentType[])Arrays.stream(source).flatMap(itemType -> Arrays.stream(ItemUtils.getStoredEnchantments(itemType))).toArray(EnchantmentType[]::new);
    }

    public Class<? extends EnchantmentType> getReturnType() {
        return EnchantmentType.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "stored enchantments of " + this.getExpr().toString(event, debug);
    }

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(expressions[0]);
        return true;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case Changer.ChangeMode.ADD, Changer.ChangeMode.REMOVE, Changer.ChangeMode.REMOVE_ALL, Changer.ChangeMode.SET -> (Class[])CollectionUtils.array((Object[])new Class[]{Enchantment[].class, EnchantmentType[].class});
            case Changer.ChangeMode.DELETE, Changer.ChangeMode.RESET -> (Class[])CollectionUtils.array((Object[])new Class[0]);
        };
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        ItemType[] source = (ItemType[])this.getExpr().getArray(event);
        EnchantmentType[] enchants = (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) && delta == null ? null : ItemUtils.asEnchantmentTypes(delta);
        switch (mode) {
            case ADD: {
                for (ItemType item : source) {
                    ItemUtils.addStoredEnchantments(item, enchants);
                }
                break;
            }
            case REMOVE: 
            case REMOVE_ALL: {
                for (ItemType item : source) {
                    ItemUtils.removeStoredEnchantments(item, enchants);
                }
                break;
            }
            case SET: 
            case DELETE: 
            case RESET: {
                for (ItemType item : source) {
                    ItemUtils.setStoredEnchantments(item, enchants);
                }
                break;
            }
        }
    }

    static {
        Skript.registerExpression(ExprStoredEnchantments.class, EnchantmentType.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] enchantment[ type]s stored in %itemtypes%", "[the] stored enchantment[ type]s of %itemtypes%", "%itemtypes%'[s] stored enchantment[ type]s"});
    }
}

