/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.mixed.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

@Name(value="Crossbow / Creeper / Wither / Wither Skull - is Charged")
@Description(value={"Checks if a crossbow, creeper, wither or wither skull is charged."})
@Examples(value={"if tool of player is charged:"})
@Since(value={"1.0.1, 1.0.3 (Wither/Wither Skull)"})
public class CondCharged
extends PropertyCondition<Object> {
    public boolean check(Object o) {
        ItemStack itemStack;
        ItemMeta itemMeta;
        if (o instanceof ItemStack && (itemMeta = (itemStack = (ItemStack)o).getItemMeta()) instanceof CrossbowMeta) {
            CrossbowMeta crossbowMeta = (CrossbowMeta)itemMeta;
            return crossbowMeta.hasChargedProjectiles();
        }
        if (o instanceof CrossbowMeta) {
            CrossbowMeta crossbowMeta = (CrossbowMeta)o;
            return crossbowMeta.hasChargedProjectiles();
        }
        if (o instanceof Wither) {
            Wither wither = (Wither)o;
            return wither.isCharged();
        }
        if (o instanceof WitherSkull) {
            WitherSkull witherSkull = (WitherSkull)o;
            return witherSkull.isCharged();
        }
        if (o instanceof Creeper) {
            Creeper creeper = (Creeper)o;
            return creeper.isPowered();
        }
        return false;
    }

    @NotNull
    protected String getPropertyName() {
        return "charged";
    }

    static {
        CondCharged.register(CondCharged.class, (String)"charged", (String)"itemstacks/entities");
    }
}

