/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.mixed.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CommandBlock;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Command Block - Command")
@Description(value={"Returns the command within a command block.\nCan be set.\nWorks with minecart with command block."})
@Examples(value={"broadcast the command of {_cmd}"})
@Since(value={"1.0.3"})
public class ExprCommandBlockCommand
extends SimpleExpression<String> {
    private Expression<Object> objectExpression;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.objectExpression = exprs[0];
        return true;
    }

    protected String @NotNull [] get(@NotNull Event e) {
        Block block;
        BlockState blockState;
        Object o = this.objectExpression.getSingle(e);
        if (o instanceof Block && (blockState = (block = (Block)o).getState()) instanceof CommandBlock) {
            CommandBlock commandBlock = (CommandBlock)blockState;
            return new String[]{commandBlock.getCommand()};
        }
        if (o instanceof CommandMinecart) {
            CommandMinecart commandMinecart = (CommandMinecart)o;
            return new String[]{commandMinecart.getCommand()};
        }
        return new String[0];
    }

    public Class<?>[] acceptChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Class[] classArray;
        switch (mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case SET: {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = String.class;
                break;
            }
            case DELETE: 
            case RESET: {
                classArray = new Class[]{};
                break;
            }
            case REMOVE: 
            case REMOVE_ALL: 
            case ADD: {
                classArray = null;
            }
        }
        return classArray;
    }

    public void change(@NotNull Event e, Object @NotNull [] delta, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Block block;
        BlockState blockState;
        Object o = this.objectExpression.getSingle(e);
        if (o instanceof Block && (blockState = (block = (Block)o).getState()) instanceof CommandBlock) {
            CommandBlock commandBlock = (CommandBlock)blockState;
            if (mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) {
                commandBlock.setCommand("");
            } else {
                Object object = delta[0];
                if (object instanceof String) {
                    string = (String)object;
                    commandBlock.setCommand(string);
                } else {
                    return;
                }
            }
            commandBlock.update();
        } else if (o instanceof CommandMinecart) {
            CommandMinecart commandMinecart = (CommandMinecart)o;
            if (mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) {
                commandMinecart.setCommand("");
            } else {
                Object object = delta[0];
                if (object instanceof String) {
                    string = (String)object;
                    commandMinecart.setCommand(string);
                }
            }
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "the command block command of " + (e == null ? "" : this.objectExpression.toString(e, debug));
    }

    static {
        Skript.registerExpression(ExprCommandBlockCommand.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] [command block] command of %object%", "%object%'[s] [command block] command"});
    }
}

