/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.server.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Enforce Whitelist")
@Description(value={"Sets if the whitelist is enforced."})
@Examples(value={"enforce the whitelist"})
@Since(value={"1.0.2"})
public class EffEnforceWhitelist
extends Effect {
    private boolean enforce;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parser) {
        this.enforce = !parser.hasTag("un");
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return (this.enforce ? "" : "un") + "enforce the server whitelist";
    }

    protected void execute(@NotNull Event event) {
        Bukkit.setWhitelistEnforced((boolean)this.enforce);
    }

    static {
        Skript.registerEffect(EffEnforceWhitelist.class, (String[])new String[]{"[:un]enforce [the] [server] whitelist"});
    }
}

