/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.world.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.papermc.paper.event.world.border.WorldBorderBoundsChangeEvent;
import io.papermc.paper.event.world.border.WorldBorderBoundsChangeFinishEvent;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="WorldBorder - New/Old Size")
@Description(value={"Returns the new/old anger of the warden in the World Border Change events.\nCan be set only within the Start variant of the event."})
@Examples(value={""})
@Since(value={"1.0.2"})
@RequiredPlugins(value={"Paper"})
public class ExprWorldBorderChangeSize
extends SimpleExpression<Double> {
    private Boolean past;
    private boolean set;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.past = parseResult.hasTag("past");
        if (this.getParser().isCurrentEvent(WorldBorderBoundsChangeEvent.class)) {
            this.set = true;
            return true;
        }
        if (this.getParser().isCurrentEvent(WorldBorderBoundsChangeFinishEvent.class)) {
            this.set = false;
            return true;
        }
        Skript.error((String)"This expression can only be used in the World Border Change events.!");
        return false;
    }

    protected Double @NotNull [] get(@NotNull Event e) {
        if (e instanceof WorldBorderBoundsChangeEvent) {
            WorldBorderBoundsChangeEvent event = (WorldBorderBoundsChangeEvent)e;
            double i = this.past != false ? event.getOldSize() : event.getNewSize();
            return new Double[]{i};
        }
        if (e instanceof WorldBorderBoundsChangeFinishEvent) {
            WorldBorderBoundsChangeFinishEvent event = (WorldBorderBoundsChangeFinishEvent)e;
            double i = this.past != false ? event.getOldSize() : event.getNewSize();
            return new Double[]{i};
        }
        return new Double[0];
    }

    public Class<?>[] acceptChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Class[] classArray;
        if (this.set && mode == Changer.ChangeMode.SET) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = Double.class;
        } else {
            classArray = null;
        }
        return classArray;
    }

    public void change(@NotNull Event e, Object @NotNull [] delta, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Object object = delta[0];
        if (object instanceof Double) {
            Double aDouble = (Double)object;
            ((WorldBorderBoundsChangeEvent)e).setNewSize(aDouble.doubleValue());
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Double> getReturnType() {
        return Double.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "the" + (this.past == null ? "" : (this.past != false ? " past" : " future")) + " worldborder size";
    }

    static {
        if (Constants.PAPER_HAS_WORLD_BORDER_EVENT) {
            Skript.registerExpression(ExprWorldBorderChangeSize.class, Double.class, (ExpressionType)Constants.EVENT_OR_SIMPLE, (String[])new String[]{"[the] [future|:past] world[ ]border size"});
        }
    }
}

