/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.command.EffectCommandEvent;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.EventValueExpression;
import it.jakegblp.lusk.utils.SkriptUtils;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Skript - Effect Command String")
@Description(value={"The command used in an effect command event.\nThis doesn't include the prefix (usually `!`).\nCan be set, reset and deleted."})
@Examples(value={"set effect command to \"give me an apple\""})
@Since(value={"1.3"})
public class ExprSkriptEffectCommand
extends EventValueExpression<String> {
    public ExprSkriptEffectCommand() {
        super(String.class, true);
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class[] classArray;
        switch (mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case SET: {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = String.class;
                break;
            }
            case DELETE: 
            case RESET: {
                classArray = new Class[]{};
                break;
            }
            case ADD: 
            case REMOVE: 
            case REMOVE_ALL: {
                classArray = null;
            }
        }
        return classArray;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (event instanceof EffectCommandEvent) {
            Object object;
            EffectCommandEvent effectCommandEvent = (EffectCommandEvent)event;
            if (mode == Changer.ChangeMode.SET && delta != null && (object = delta[0]) instanceof String) {
                String string = (String)object;
                effectCommandEvent.setCommand(string);
            } else if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
                effectCommandEvent.setCommand("");
            }
        }
    }

    static {
        SkriptUtils.register(ExprSkriptEffectCommand.class, String.class, "[event-|the ][skript] effect command [string]");
    }
}

