/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.version.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import com.vdurmont.semver4j.SemverException;
import it.jakegblp.lusk.utils.LuskUtils;
import org.jetbrains.annotations.NotNull;

@Name(value="Version - is Valid")
@Description(value={"Checks if the string is a valid version"})
@Examples(value={"if \"1.19.2\" is a valid version:\n\tbroadcast version \"1.19.2\""})
@Since(value={"1.0.0"})
public class CondVersionValid
extends PropertyCondition<String> {
    public boolean check(String version) {
        try {
            LuskUtils.parseVersion(version);
        }
        catch (SemverException e) {
            return false;
        }
        return true;
    }

    @NotNull
    protected String getPropertyName() {
        return "valid version";
    }

    static {
        CondVersionValid.register(CondVersionValid.class, (String)"[a] valid version[s]", (String)"strings");
    }
}

