/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.version.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.vdurmont.semver4j.Semver;
import com.vdurmont.semver4j.SemverException;
import it.jakegblp.lusk.utils.LuskUtils;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Version - from String")
@Description(value={"Gets a version from a string."})
@Examples(value={"if player's version < version \"1.19.2\":\n\tbroadcast \"%player% can't play on this server\"\nelse:\n\tkick player"})
@Since(value={"1.0.0"})
public class ExprVersion
extends SimpleExpression<Semver> {
    private Expression<String> strings;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.strings = exprs[0];
        return true;
    }

    protected Semver @NotNull [] get(@NotNull Event e) {
        String[] s = (String[])this.strings.getArray(e);
        if (s.length != 0) {
            ArrayList<Semver> v = new ArrayList<Semver>();
            for (String value : s) {
                try {
                    v.add(LuskUtils.parseVersion(value));
                }
                catch (SemverException semverException) {
                    // empty catch block
                }
            }
            return v.toArray(new Semver[0]);
        }
        return new Semver[0];
    }

    public boolean isSingle() {
        return this.strings.isSingle();
    }

    @NotNull
    public Class<? extends Semver> getReturnType() {
        return Semver.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "the version " + (e == null ? "" : this.strings.toString(e, debug));
    }

    static {
        Skript.registerExpression(ExprVersion.class, Semver.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] version[s] %strings%"});
    }
}

