/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.utils;

import java.util.Arrays;
import java.util.stream.Stream;
import org.bukkit.Rotation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.jetbrains.annotations.Range;

public class ItemFrameUtils {
    public static Rotation sumRotations(Stream<? extends Rotation> rotations, Rotation rotation, int times) {
        int total = rotations.mapToInt(Enum::ordinal).sum() * times + rotation.ordinal();
        return Rotation.values()[total % Rotation.values().length];
    }

    public static Rotation subtractRotations(Rotation ... rotations) {
        int total = Arrays.stream(rotations).mapToInt(Enum::ordinal).reduce(0, (a, b) -> a - b);
        return Rotation.values()[(total % Rotation.values().length + Rotation.values().length) % Rotation.values().length];
    }

    public static void rotateItemFrame(Entity entity, boolean clockwise, @Range(from=1L, to=0x7FFFFFFFL) int times) {
        if (entity instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            Rotation rotation = itemFrame.getRotation();
            for (int i = 0; i < times; ++i) {
                rotation = clockwise ? rotation.rotateClockwise() : rotation.rotateCounterClockwise();
            }
            itemFrame.setRotation(rotation);
        }
    }
}

