/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.utils;

import ch.njol.skript.Skript;
import ch.njol.skript.util.ColorRGB;
import ch.njol.util.Kleenean;
import com.vdurmont.semver4j.Semver;
import it.jakegblp.lusk.utils.Constants;
import java.text.MessageFormat;
import java.util.List;
import java.util.regex.Matcher;
import java.util.stream.IntStream;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class LuskUtils {
    public static Semver parseVersion(String s) {
        if (((String)s).matches("^\\d+.\\d+$")) {
            s = (String)s + ".0";
        }
        return new Semver((String)s, Semver.SemverType.STRICT);
    }

    public static Semver parseVersionTruncated(String s) {
        Matcher matcher = Constants.REGEX_TRUNCATED_VERSION.matcher(s);
        if (matcher.find()) {
            s = matcher.group();
        }
        return LuskUtils.parseVersion(s);
    }

    public static void consoleLog(String message, Object ... args) {
        LuskUtils.send((CommandSender)Bukkit.getConsoleSender(), message, args);
    }

    public static void warning(String message, Object ... args) {
        LuskUtils.send((CommandSender)Bukkit.getConsoleSender(), "&eWARNING: " + message, args);
    }

    public static void send(@NotNull CommandSender sender, String message, Object ... args) {
        LuskUtils.sendMessage(sender, Constants.LUSK_PREFIX + "&7" + MessageFormat.format(message, args));
    }

    public static void sendMessage(@NotNull CommandSender sender, String message) {
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
    }

    public static String toSkriptConfigNumberAccuracy(String string) {
        return Constants.REGEX_NUMBER_WITH_DECIMAL.matcher(string).replaceAll(n -> Skript.toString((double)Double.parseDouble(n.group())));
    }

    public static long getTotalNeededXP(int level) {
        long xp = level <= 0 ? 0L : (level <= 15 ? (long)(level * level + 6 * level) : (level <= 30 ? (long)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0) : (long)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0)));
        return xp;
    }

    public static int[] getNotNullIndices(List<?> list) {
        return IntStream.range(0, list.size()).filter(i -> list.get(i) != null).toArray();
    }

    @NotNull
    public static Kleenean getKleenean(boolean a, boolean b) {
        if (a) {
            return Kleenean.TRUE;
        }
        if (b) {
            return Kleenean.FALSE;
        }
        return Kleenean.UNKNOWN;
    }

    public static ColorRGB getColorAsRGB(@NotNull Color color) {
        return new ColorRGB(color.getRed(), color.getGreen(), color.getBlue());
    }
}

