/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.utils;

import ch.njol.skript.registrations.Classes;
import com.google.common.collect.ImmutableMap;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import it.jakegblp.lusk.Lusk;
import it.jakegblp.lusk.utils.ClassUtils;
import it.jakegblp.lusk.utils.Constants;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.bukkit.Registry;
import org.jetbrains.annotations.Nullable;

public class RegistryUtils {
    public static ImmutableMap<Class<?>, Registry<?>> generateRegistries() {
        Class[] classArray;
        HashMap registries = new HashMap();
        if (Constants.PAPER_HAS_PAPER_REGISTRY_KEY) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = RegistryKey.class;
            classArray = classArray2;
            classArray2[1] = Registry.class;
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = Registry.class;
        }
        for (Class clazz : classArray) {
            for (Field field : clazz.getDeclaredFields()) {
                if (field.getType() != clazz || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
                String className = ClassUtils.getFieldClassGenerics(field)[0];
                try {
                    Class<?> theClass = Class.forName(className);
                    if (Classes.getExactClassInfo(theClass) != null) continue;
                    registries.putIfAbsent(Class.forName(className), RegistryUtils.getRegistryFromField(field));
                }
                catch (ClassNotFoundException | IllegalAccessException e) {
                    String message = e instanceof IllegalAccessException ? "The class '" + className + "' is not accessible." : "The class '" + className + "' was not found.";
                    Lusk.getInstance().getLogger().severe(message);
                }
            }
        }
        return ImmutableMap.copyOf(registries);
    }

    @Nullable
    public static Registry<?> getRegistryFromField(Field field) throws IllegalAccessException {
        Object object = field.get(null);
        if (Constants.PAPER_HAS_PAPER_REGISTRY_KEY && object instanceof RegistryKey) {
            RegistryKey registryKey = (RegistryKey)object;
            return RegistryAccess.registryAccess().getRegistry(registryKey);
        }
        if (object instanceof Registry) {
            Registry registry = (Registry)object;
            return registry;
        }
        return null;
    }
}

