/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.utils;

import it.jakegblp.lusk.api.enums.Axis4D;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.map.MapCursor;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4d;
import org.joml.AxisAngle4f;
import org.joml.Quaterniondc;
import org.joml.Quaternionfc;
import org.joml.Vector2d;
import org.joml.Vector2i;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3i;
import org.joml.Vector4d;
import org.joml.Vector4f;
import org.joml.Vector4i;

public class VectorUtils {
    public static EulerAngle toEulerAngle(Vector vector) {
        return new EulerAngle(vector.getX(), vector.getY(), vector.getZ());
    }

    public static Vector toVector(EulerAngle eulerAngle) {
        return new Vector(eulerAngle.getX(), eulerAngle.getY(), eulerAngle.getZ());
    }

    public static Vector toDegreesVector(Vector vector) {
        return new Vector(Math.toDegrees(vector.getX()), Math.toDegrees(vector.getY()), Math.toDegrees(vector.getZ()));
    }

    public static Vector toDegreesVector(EulerAngle eulerAngle) {
        return new Vector(Math.toDegrees(eulerAngle.getX()), Math.toDegrees(eulerAngle.getY()), Math.toDegrees(eulerAngle.getZ()));
    }

    public static Vector toRadiansVector(Vector vector) {
        return new Vector(Math.toRadians(vector.getX()), Math.toRadians(vector.getY()), Math.toRadians(vector.getZ()));
    }

    public static EulerAngle toRadiansEulerAngle(Vector vector) {
        return new EulerAngle(Math.toRadians(vector.getX()), Math.toRadians(vector.getY()), Math.toRadians(vector.getZ()));
    }

    @Nullable
    public static Number getCoordinate(Object object, Axis4D axis) {
        if (object instanceof Location) {
            Location location = (Location)object;
            return switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Axis4D.X -> location.getX();
                case Axis4D.Y -> location.getY();
                case Axis4D.Z -> location.getZ();
                case Axis4D.W -> null;
            };
        }
        if (object instanceof Block) {
            Block block = (Block)object;
            return switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Axis4D.X -> block.getX();
                case Axis4D.Y -> block.getY();
                case Axis4D.Z -> block.getZ();
                case Axis4D.W -> null;
            };
        }
        if (object instanceof BlockState) {
            BlockState blockState = (BlockState)object;
            return switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Axis4D.X -> blockState.getX();
                case Axis4D.Y -> blockState.getY();
                case Axis4D.Z -> blockState.getZ();
                case Axis4D.W -> null;
            };
        }
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            return switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Axis4D.X -> vector.getX();
                case Axis4D.Y -> vector.getY();
                case Axis4D.Z -> vector.getZ();
                case Axis4D.W -> null;
            };
        }
        if (object instanceof Chunk) {
            Chunk chunk = (Chunk)object;
            return switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Axis4D.X -> chunk.getX();
                case Axis4D.Z -> chunk.getZ();
                case Axis4D.Y, Axis4D.W -> null;
            };
        }
        if (object instanceof EulerAngle) {
            EulerAngle eulerAngle = (EulerAngle)object;
            return switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Axis4D.X -> eulerAngle.getX();
                case Axis4D.Y -> eulerAngle.getY();
                case Axis4D.Z -> eulerAngle.getZ();
                case Axis4D.W -> null;
            };
        }
        if (object instanceof Quaternionfc) {
            Quaternionfc quaternionfc = (Quaternionfc)object;
            return switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Axis4D.X -> Float.valueOf(quaternionfc.x());
                case Axis4D.Y -> Float.valueOf(quaternionfc.y());
                case Axis4D.Z -> Float.valueOf(quaternionfc.z());
                case Axis4D.W -> Float.valueOf(quaternionfc.w());
            };
        }
        if (object instanceof Quaterniondc) {
            Quaterniondc quaterniondc = (Quaterniondc)object;
            return switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Axis4D.X -> quaterniondc.x();
                case Axis4D.Y -> quaterniondc.y();
                case Axis4D.Z -> quaterniondc.z();
                case Axis4D.W -> quaterniondc.w();
            };
        }
        if (object instanceof AxisAngle4f) {
            AxisAngle4f axisAngle4f = (AxisAngle4f)object;
            return switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Axis4D.X -> Float.valueOf(axisAngle4f.x);
                case Axis4D.Y -> Float.valueOf(axisAngle4f.y);
                case Axis4D.Z -> Float.valueOf(axisAngle4f.z);
                case Axis4D.W -> Float.valueOf(axisAngle4f.angle);
            };
        }
        if (object instanceof AxisAngle4d) {
            AxisAngle4d axisAngle4d = (AxisAngle4d)object;
            return switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Axis4D.X -> axisAngle4d.x;
                case Axis4D.Y -> axisAngle4d.y;
                case Axis4D.Z -> axisAngle4d.z;
                case Axis4D.W -> axisAngle4d.angle;
            };
        }
        if (object instanceof Vector2d) {
            Vector2d vector2d = (Vector2d)object;
            return switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Axis4D.X -> vector2d.x;
                case Axis4D.Y -> vector2d.y;
                case Axis4D.Z, Axis4D.W -> null;
            };
        }
        if (object instanceof Vector2i) {
            Vector2i vector2i = (Vector2i)object;
            return switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Axis4D.X -> vector2i.x;
                case Axis4D.Y -> vector2i.y;
                case Axis4D.Z, Axis4D.W -> null;
            };
        }
        if (object instanceof Vector3d) {
            Vector3d vector3d = (Vector3d)object;
            return switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Axis4D.X -> vector3d.x;
                case Axis4D.Y -> vector3d.y;
                case Axis4D.Z -> vector3d.z;
                case Axis4D.W -> null;
            };
        }
        if (object instanceof Vector3f) {
            Vector3f vector3f = (Vector3f)object;
            return switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Axis4D.X -> Float.valueOf(vector3f.x);
                case Axis4D.Y -> Float.valueOf(vector3f.y);
                case Axis4D.Z -> Float.valueOf(vector3f.z);
                case Axis4D.W -> null;
            };
        }
        if (object instanceof Vector3i) {
            Vector3i vector3i = (Vector3i)object;
            return switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Axis4D.X -> vector3i.x;
                case Axis4D.Y -> vector3i.y;
                case Axis4D.Z -> vector3i.z;
                case Axis4D.W -> null;
            };
        }
        if (object instanceof Vector4d) {
            Vector4d vector4d = (Vector4d)object;
            return switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Axis4D.X -> vector4d.x;
                case Axis4D.Y -> vector4d.y;
                case Axis4D.Z -> vector4d.z;
                case Axis4D.W -> vector4d.w;
            };
        }
        if (object instanceof Vector4f) {
            Vector4f vector4f = (Vector4f)object;
            return switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Axis4D.X -> Float.valueOf(vector4f.x);
                case Axis4D.Y -> Float.valueOf(vector4f.y);
                case Axis4D.Z -> Float.valueOf(vector4f.z);
                case Axis4D.W -> Float.valueOf(vector4f.w);
            };
        }
        if (object instanceof Vector4i) {
            Vector4i vector4i = (Vector4i)object;
            return switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Axis4D.X -> vector4i.x;
                case Axis4D.Y -> vector4i.y;
                case Axis4D.Z -> vector4i.z;
                case Axis4D.W -> vector4i.w;
            };
        }
        if (object instanceof MapCursor) {
            MapCursor mapCursor = (MapCursor)object;
            return switch (axis) {
                case Axis4D.X -> mapCursor.getX();
                case Axis4D.Y -> mapCursor.getY();
                default -> null;
            };
        }
        return null;
    }
}

