/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk;

import ch.njol.skript.Skript;
import ch.njol.skript.util.Version;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import it.jakegblp.lusk.Lusk;
import it.jakegblp.lusk.utils.Constants;
import it.jakegblp.lusk.utils.LuskUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class UpdateChecker
implements Listener {
    public static final Function<String, URL> GET_URL_METHOD = Skript.methodExists(URL.class, (String)"of", (Class[])new Class[]{URI.class, URLStreamHandler.class}) ? string -> {
        try {
            return URL.of(URI.create(string), null);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    } : string -> {
        try {
            return new URL(null, (String)string);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    };
    private final Lusk plugin;
    private final Version pluginVersion;
    private Version currentUpdateVersion;

    public UpdateChecker(Lusk plugin) {
        this.plugin = plugin;
        this.pluginVersion = new Version(plugin.getDescription().getVersion());
        this.checkUpdate();
        this.setupJoinListener();
    }

    private void setupJoinListener() {
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            private void onJoin(PlayerJoinEvent event) {
                Player player = event.getPlayer();
                if (!player.hasPermission("lusk.update.check")) {
                    return;
                }
                Bukkit.getScheduler().runTaskLater((Plugin)UpdateChecker.this.plugin, () -> UpdateChecker.this.getUpdateVersion(true).thenApply(version -> {
                    LuskUtils.send((CommandSender)player, "Lusk is &c&lOUTDATED&f!", new Object[0]);
                    LuskUtils.send((CommandSender)player, "New version: {0}", version);
                    LuskUtils.send((CommandSender)player, "Download at: https://github.com/JakeGBLP/Lusk/releases", new Object[0]);
                    return true;
                }), 30L);
            }
        }, (Plugin)this.plugin);
    }

    private void checkUpdate() {
        LuskUtils.consoleLog("&oChecking for update...", new Object[0]);
        ((CompletableFuture)this.getUpdateVersion(false).thenApply(version -> {
            LuskUtils.consoleLog("&cLusk is not up to date!", new Object[0]);
            if (Constants.VERSION_SERVER.isGreaterThan(Constants.VERSION_SERVER_NEWEST_SUPPORTED)) {
                LuskUtils.consoleLog("&cYou're running Minecraft {0} which is not supported by Lusk {1}, please update.", Constants.VERSION_SERVER, this.pluginVersion);
            }
            LuskUtils.consoleLog("&a&lUpdate Available:", new Object[0]);
            LuskUtils.consoleLog(" &l\u00bb&c   {0} &7\u2192&a {1}", this.pluginVersion, version);
            LuskUtils.consoleLog(" &l\u00bb&7 Download at: https://github.com/JakeGBLP/Lusk/releases", new Object[0]);
            return true;
        })).exceptionally(throwable -> {
            LuskUtils.consoleLog("&aLusk is up to date!", new Object[0]);
            if (Constants.VERSION_SERVER.isLowerThan(Constants.VERSION_SERVER_OLDEST_SUPPORTED)) {
                LuskUtils.warning("You're running Minecraft {0} which is not supported by Lusk {1}, stability is not guaranteed.", Constants.VERSION_SERVER, this.pluginVersion);
            }
            if (Constants.VERSION_SKRIPT.isLowerThan(Constants.VERSION_SKRIPT_OLDEST_SUPPORTED)) {
                LuskUtils.warning("You're running Skript {0} which is not supported by Lusk {1}, stability is not guaranteed.", Constants.VERSION_SKRIPT, this.pluginVersion);
            }
            return true;
        });
    }

    private CompletableFuture<Version> getUpdateVersion(boolean async) {
        CompletableFuture<Version> future = new CompletableFuture<Version>();
        if (this.currentUpdateVersion != null) {
            future.complete(this.currentUpdateVersion);
        } else {
            this.getLatestReleaseVersion(async).thenApply(version -> {
                if (version.compareTo(this.pluginVersion) <= 0) {
                    future.cancel(true);
                } else {
                    this.currentUpdateVersion = version;
                    future.complete(this.currentUpdateVersion);
                }
                return true;
            });
        }
        return future;
    }

    private CompletableFuture<Version> getLatestReleaseVersion(boolean async) {
        CompletableFuture<Version> future = new CompletableFuture<Version>();
        if (async) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                Version latest = this.getLatestVersionFromGitHub();
                if (latest == null) {
                    future.cancel(true);
                }
                future.complete(latest);
            });
        } else {
            Version latest = this.getLatestVersionFromGitHub();
            if (latest == null) {
                future.cancel(true);
            }
            future.complete(latest);
        }
        return future;
    }

    @Nullable
    private Version getLatestVersionFromGitHub() {
        try {
            URL url = GET_URL_METHOD.apply("https://api.github.com/repos/JakeGBLP/Lusk/releases/latest");
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            JsonObject jsonObject = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
            String tag_name = jsonObject.get("tag_name").getAsString();
            return new Version(tag_name);
        }
        catch (IOException e) {
            LuskUtils.consoleLog("&cChecking for update failed!", new Object[0]);
            return null;
        }
    }
}

