/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.api;

import it.jakegblp.lusk.Lusk;
import it.jakegblp.lusk.api.events.AnvilGuiClickEvent;
import it.jakegblp.lusk.api.events.AnvilGuiCloseEvent;
import it.jakegblp.lusk.api.events.AnvilGuiOpenEvent;
import it.jakegblp.lusk.libs.anvilgui.AnvilGUI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnvilGuiWrapper {
    private static final Map<AnvilGuiWrapper, Set<UUID>> OPEN_GUIS = new HashMap<AnvilGuiWrapper, Set<UUID>>();
    private final AnvilGUI.Builder builder = new AnvilGUI.Builder();
    private AnvilGUI anvilGUI;
    private String title;
    private String text;
    private ItemStack left;
    private ItemStack right;
    private ItemStack output;
    private int[] interactableSlots = null;
    private boolean isClosing;
    private boolean preventsClose;

    public AnvilGuiWrapper() {
        this.builder.plugin((Plugin)Lusk.getInstance());
        this.builder.onClick((slot, snapshot) -> List.of(AnvilGUI.ResponseAction.run(() -> Lusk.callEvent((Event)new AnvilGuiClickEvent(this, (AnvilGUI.StateSnapshot)snapshot, (int)slot)))));
        this.builder.onClose(snapshot -> {
            this.isClosing = true;
            this.removeUUIDs(snapshot.getPlayer().getUniqueId());
            Lusk.callEvent((Event)new AnvilGuiCloseEvent(this, (AnvilGUI.StateSnapshot)snapshot));
        });
    }

    public AnvilGuiWrapper(AnvilGuiWrapper anvilGuiWrapper) {
        this.builder.plugin((Plugin)Lusk.getInstance());
        this.setLeft(anvilGuiWrapper.getLeft());
        this.setRight(anvilGuiWrapper.getRight());
        this.setOutput(anvilGuiWrapper.getOutput());
        this.setTitle(anvilGuiWrapper.getTitle());
        this.setText(anvilGuiWrapper.getText());
        this.preventsClose = false;
        this.isClosing = false;
        this.anvilGUI = null;
        this.interactableSlots = anvilGuiWrapper.interactableSlots;
    }

    public void open(Player ... players) {
        Set playerSet = OPEN_GUIS.computeIfAbsent(this, k -> new HashSet());
        int length = players.length;
        for (int i = 0; i < length; ++i) {
            Player player = players[i];
            if (i == length - 1) {
                this.anvilGUI = this.getBuilder().open(player);
            } else {
                this.getBuilder().open(player);
            }
            playerSet.add(player.getUniqueId());
            Lusk.callEvent((Event)new AnvilGuiOpenEvent(this, player));
        }
    }

    public static Map<AnvilGuiWrapper, Set<UUID>> getOpenGuis() {
        return OPEN_GUIS;
    }

    public void closeAndOpen(Player ... players) {
        HashSet<AnvilGuiWrapper> guisToClose = new HashSet<AnvilGuiWrapper>();
        block0: for (Map.Entry<AnvilGuiWrapper, Set<UUID>> entry : OPEN_GUIS.entrySet()) {
            for (Player player : players) {
                if (!entry.getValue().contains(player.getUniqueId())) continue;
                guisToClose.add(entry.getKey());
                continue block0;
            }
        }
        for (AnvilGuiWrapper gui : guisToClose) {
            gui.close();
            OPEN_GUIS.remove(gui);
        }
        for (Iterator<Map.Entry<AnvilGuiWrapper, Set<UUID>>> iterator : players) {
            this.open(new Player[]{iterator});
        }
    }

    public boolean isOpenTo(Player ... players) {
        if (OPEN_GUIS.containsKey(this)) {
            return OPEN_GUIS.get(this).containsAll(Arrays.stream(players).map(Entity::getUniqueId).collect(Collectors.toSet()));
        }
        return false;
    }

    public static boolean isViewingAnyAnvilGui(Player ... players) {
        return Arrays.stream(players).allMatch(player -> OPEN_GUIS.values().stream().anyMatch(uuids -> uuids.contains(player.getUniqueId())));
    }

    public static AnvilGuiWrapper getOpenAnvilGui(Player player) {
        return OPEN_GUIS.entrySet().stream().filter(entry -> ((Set)entry.getValue()).contains(player.getUniqueId())).findFirst().map(Map.Entry::getKey).orElse(null);
    }

    public void setInteractableSlots(int ... slots) {
        this.interactableSlots = Arrays.stream(slots).distinct().toArray();
        this.builder.interactableSlots(this.interactableSlots);
    }

    public void addInteractableSlots(int ... slots) {
        this.setInteractableSlots(ArrayUtils.addAll((int[])this.interactableSlots, (int[])slots));
    }

    public void removeInteractableSlots(int ... slots) {
        this.setInteractableSlots(ArrayUtils.removeAll((int[])this.interactableSlots, (int[])slots));
    }

    public void resetInteractableSlots() {
        this.setInteractableSlots(new int[0]);
    }

    public int @Nullable [] getInteractableSlots() {
        return this.interactableSlots;
    }

    private void removeUUIDs(UUID ... uuids) {
        Set<UUID> playerSet = OPEN_GUIS.get(this);
        if (playerSet != null) {
            List.of(uuids).forEach(playerSet::remove);
            if (playerSet.isEmpty()) {
                OPEN_GUIS.remove(this);
            }
        }
    }

    private void internallyClose() {
        if (this.anvilGUI != null) {
            this.anvilGUI.closeInventory();
            this.isClosing = false;
            OPEN_GUIS.remove(this);
        }
    }

    public void close() {
        if (this.isClosing && this.isPreventsClose()) {
            Bukkit.getScheduler().runTaskLater((Plugin)Lusk.getInstance(), this::internallyClose, 1L);
            return;
        }
        this.internallyClose();
    }

    public void preventClose() {
        this.builder.preventClose();
        this.preventsClose = true;
    }

    public void setLeft(ItemStack left) {
        this.left = left;
        this.builder.itemLeft(left);
    }

    public void setRight(ItemStack right) {
        this.right = right;
        this.builder.itemRight(right);
    }

    public void setOutput(ItemStack output) {
        this.output = output;
        this.builder.itemOutput(output);
    }

    public void setText(String text) {
        this.text = text;
        this.builder.text(text);
    }

    public void setTitle(@NotNull String title) {
        this.title = title;
        this.builder.title(title);
    }

    public String toString() {
        return "anvil gui" + (String)(this.getTitle() != null ? " named " + this.getTitle() : "") + (String)(this.getText() != null ? " with text " + this.getText() : "");
    }

    @Generated
    public AnvilGUI.Builder getBuilder() {
        return this.builder;
    }

    @Generated
    public AnvilGUI getAnvilGUI() {
        return this.anvilGUI;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public ItemStack getLeft() {
        return this.left;
    }

    @Generated
    public ItemStack getRight() {
        return this.right;
    }

    @Generated
    public ItemStack getOutput() {
        return this.output;
    }

    @Generated
    public boolean isPreventsClose() {
        return this.preventsClose;
    }
}

