/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.api.enums;

import it.jakegblp.lusk.utils.VectorUtils;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.bukkit.entity.ArmorStand;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum BodyPart {
    LEFT_ARM(ArmorStand::setLeftArmPose, ArmorStand::getLeftArmPose),
    RIGHT_ARM(ArmorStand::setRightArmPose, ArmorStand::getRightArmPose),
    LEFT_LEG(ArmorStand::setLeftLegPose, ArmorStand::getLeftLegPose),
    RIGHT_LEG(ArmorStand::setRightLegPose, ArmorStand::getRightLegPose),
    HEAD(ArmorStand::setHeadPose, ArmorStand::getHeadPose),
    BODY(ArmorStand::setBodyPose, ArmorStand::getBodyPose);

    private final BiConsumer<ArmorStand, EulerAngle> poseSetter;
    private final Function<ArmorStand, EulerAngle> poseGetter;

    private BodyPart(BiConsumer<ArmorStand, EulerAngle> poseSetter, Function<ArmorStand, EulerAngle> poseGetter) {
        this.poseSetter = poseSetter;
        this.poseGetter = poseGetter;
    }

    public void set(@NotNull ArmorStand armorStand, @Nullable Vector vector) {
        this.poseSetter.accept(armorStand, vector == null ? EulerAngle.ZERO : VectorUtils.toRadiansEulerAngle(vector));
    }

    public Vector get(@NotNull ArmorStand armorStand) {
        return VectorUtils.toDegreesVector(this.poseGetter.apply(armorStand));
    }
}

