/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.api.skript;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.ParseContext;
import ch.njol.util.StringUtils;
import ch.njol.yggdrasil.Fields;
import com.google.common.base.Preconditions;
import it.jakegblp.lusk.api.GenericRelation;
import it.jakegblp.lusk.utils.BorrowedUtils;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collections;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistryClassInfo<T extends Keyed>
extends ClassInfo<T> {
    private final Registry<T> registry;
    @Nullable
    private final String prefix;
    @Nullable
    private final String suffix;

    public static <T extends Keyed> RegistryClassInfo<T> create(@NotNull Registry<T> registry, @NotNull Class<T> registryClass, @NotNull String codename) {
        return RegistryClassInfo.create(registry, registryClass, true, codename, null, null);
    }

    public static <T extends Keyed> RegistryClassInfo<T> create(@NotNull Registry<T> registry, @NotNull Class<T> registryClass, @NotNull String codename, @Nullable String prefix, @Nullable String suffix) {
        return RegistryClassInfo.create(registry, registryClass, true, codename, prefix, suffix);
    }

    public static <T extends Keyed> RegistryClassInfo<T> create(@NotNull Registry<T> registry, @NotNull Class<T> registryClass, boolean usage, @NotNull String codename) {
        return RegistryClassInfo.create(registry, registryClass, usage, codename, null, null);
    }

    public static <T extends Keyed> RegistryClassInfo<T> create(@NotNull Registry<T> registry, @NotNull Class<T> registryClass, boolean usage, @NotNull String codename, @Nullable String prefix, @Nullable String suffix) {
        Preconditions.checkArgument((registry != null ? 1 : 0) != 0, (Object)"Registry cannot be null");
        Preconditions.checkArgument((registryClass != null ? 1 : 0) != 0, (Object)"RegistryClass cannot be null");
        Preconditions.checkArgument((!codename.isEmpty() ? 1 : 0) != 0, (Object)"Codename cannot be empty");
        return new RegistryClassInfo<T>(registry, registryClass, usage, codename, prefix, suffix);
    }

    public RegistryClassInfo(Registry<T> registry, Class<T> registryClass, boolean usage, String codename, @Nullable String prefix, @Nullable String suffix) {
        super(registryClass, codename);
        this.registry = registry;
        this.prefix = prefix == null ? null : prefix.replaceAll(" ", "_");
        String string = this.suffix = suffix == null ? null : suffix.replaceAll(" ", "_");
        if (!CompatibilityUtils.exactComparatorExists(registryClass, registryClass)) {
            CompatibilityUtils.registerComparator(registryClass, registryClass, (o1, o2) -> GenericRelation.get(o1.equals(o2)));
        }
        if (usage) {
            this.usage(new String[]{this.getNames()});
        }
        this.supplier(() -> registry.iterator());
        this.parser(new Parser<T>(){

            @Nullable
            public T parse(String string, ParseContext context) {
                return RegistryClassInfo.this.parse(string);
            }

            @NotNull
            public String toString(T o, int flags) {
                return RegistryClassInfo.this.toString(o);
            }

            @NotNull
            public String toVariableNameString(T o) {
                return this.toString((T)o, 0);
            }
        });
        this.serializer(new Serializer<T>(){

            @NotNull
            public Fields serialize(T object) {
                Fields fields = new Fields();
                fields.putObject("key", (Object)object.getKey().toString());
                return fields;
            }

            public void deserialize(T o, @NotNull Fields f) {
            }

            protected T deserialize(@NotNull Fields fields) throws StreamCorruptedException {
                String key = (String)fields.getObject("key", String.class);
                if (key == null) {
                    throw new StreamCorruptedException("Key is null");
                }
                NamespacedKey namespacedKey = NamespacedKey.fromString((String)key);
                if (namespacedKey == null) {
                    throw new StreamCorruptedException("NamespacedKey is null for key: " + key);
                }
                Keyed registryObject = RegistryClassInfo.this.registry.get(namespacedKey);
                if (registryObject == null) {
                    throw new StreamCorruptedException("RegistryObject is null for key: " + key);
                }
                return registryObject;
            }

            public boolean mustSyncDeserialization() {
                return true;
            }

            protected boolean canBeInstantiated() {
                return false;
            }
        });
    }

    public String getNames() {
        ArrayList keys = new ArrayList();
        this.registry.iterator().forEachRemaining(object -> keys.add(this.getName(object)));
        Collections.sort(keys);
        return StringUtils.join(keys, (String)", ");
    }

    private String getName(T object) {
        Object key = object.getKey().getKey();
        if (this.prefix != null && !this.prefix.isEmpty()) {
            key = this.prefix + "_" + (String)key;
        }
        if (this.suffix != null && !this.suffix.isEmpty()) {
            key = (String)key + "_" + this.suffix;
        }
        return key;
    }

    @NotNull
    public String toString(T object) {
        NamespacedKey namespacedKey;
        try {
            namespacedKey = object.getKey();
        }
        catch (IllegalArgumentException ignore) {
            return "invalid key for: " + String.valueOf(object);
        }
        Object key = namespacedKey.getKey();
        if (this.prefix != null && !this.prefix.isEmpty()) {
            key = this.prefix + "_" + (String)key;
        }
        if (this.suffix != null && !this.suffix.isEmpty()) {
            key = (String)key + "_" + this.suffix;
        }
        return namespacedKey.getNamespace() + ":" + (String)key;
    }

    @Nullable
    private T parse(String string) {
        NamespacedKey key;
        string = string.replace(" ", "_");
        if (this.prefix != null) {
            if (!string.contains(this.prefix)) {
                return null;
            }
            string = string.replace(this.prefix + "_", "").replace(this.prefix, "");
        }
        if (this.suffix != null) {
            if (!string.contains(this.suffix)) {
                return null;
            }
            string = string.replace("_" + this.suffix, "").replace(this.suffix, "");
        }
        if ((key = BorrowedUtils.getNamespacedKey(string = string.trim(), false)) == null) {
            return null;
        }
        return (T)this.registry.get(key);
    }
}

