/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.anvilgui.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.AnvilGuiWrapper;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Anvil GUI - Open")
@Description(value={"Opens an anvil GUI to one or more players.\n*NOTES*:\n- Anvil GUIs are always opened 1 tick later.\n- You can only open an anvil GUI for a player if the player is not already viewing another (or this) anvil GUI.\n- Using `force` will forcibly close the anvil GUI the player is currently viewing to open a new one. Be aware that, due to how anvil GUIs work, closing an anvil GUI is global, meaning it will be closed for all players viewing it. To avoid this, ensure that you create per-player anvil GUIs.\n"})
@Examples(value={"open a new anvil gui to the player"})
@Since(value={"1.3"})
public class EffAnvilGuiOpen
extends Effect {
    private Expression<AnvilGuiWrapper> anvilGuiWrapperExpression;
    private Expression<Player> playerExpression;
    private boolean force;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parser) {
        this.anvilGuiWrapperExpression = expressions[0];
        this.playerExpression = expressions[1];
        this.force = parser.hasTag("force");
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return (this.force ? "force " : "") + "open anvil gui " + this.anvilGuiWrapperExpression.toString(event, debug) + " to " + this.playerExpression.toString(event, debug);
    }

    protected void execute(@NotNull Event event) {
        Player[] players;
        AnvilGuiWrapper wrapper = (AnvilGuiWrapper)this.anvilGuiWrapperExpression.getSingle(event);
        if (wrapper == null) {
            return;
        }
        for (Player player : players = (Player[])this.playerExpression.getAll(event)) {
            if (this.force) {
                wrapper.closeAndOpen(player);
                return;
            }
            wrapper.open(player);
        }
    }

    static {
        Skript.registerEffect(EffAnvilGuiOpen.class, (String[])new String[]{"[:force] open [lusk] anvil[(-| )gui] %anvilguiinventory% to %players%"});
    }
}

