/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.anvilgui.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.AnvilGuiWrapper;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Anvil GUI - Prevent Closing")
@Description(value={"Prevents an anvil gui from closing.\n*NOTES*:\n- This effect must be used *BEFORE* the gui is opened; if you need to use it after it's already opened you'll have to open it again.\n- If this effect is used you'll need to use the `Anvil GUI - Close` effect to close the gui."})
@Examples(value={"prevent event-anvilguiinventory from closing"})
@Since(value={"1.3"})
public class EffAnvilGuiPreventClosing
extends Effect {
    private Expression<AnvilGuiWrapper> anvilGuiWrapperExpression;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parser) {
        this.anvilGuiWrapperExpression = expressions[0];
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "prevent " + this.anvilGuiWrapperExpression.toString(event, debug) + " from closing";
    }

    protected void execute(@NotNull Event event) {
        AnvilGuiWrapper wrapper = (AnvilGuiWrapper)this.anvilGuiWrapperExpression.getSingle(event);
        if (wrapper == null) {
            return;
        }
        wrapper.preventClose();
    }

    static {
        Skript.registerEffect(EffAnvilGuiPreventClosing.class, (String[])new String[]{"prevent [[lusk] anvil[(-| )gui]] %anvilguiinventory% from (closing|being closed)"});
    }
}

