/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.anvilgui.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import it.jakegblp.lusk.api.AnvilGuiWrapper;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Anvil GUI - Opened Anvil GUI")
@Description(value={"Gets the open anvil GUI of one or more players."})
@Examples(value={"set {_anvilGui} to the currently open anvil gui of {_player}"})
@Since(value={"1.3"})
public class ExprAnvilGuiOfPlayer
extends SimplePropertyExpression<Player, AnvilGuiWrapper> {
    @NotNull
    protected String getPropertyName() {
        return "currently open anvil gui";
    }

    @NotNull
    public Class<? extends AnvilGuiWrapper> getReturnType() {
        return AnvilGuiWrapper.class;
    }

    @Nullable
    public AnvilGuiWrapper convert(Player from) {
        return AnvilGuiWrapper.getOpenAnvilGui(from);
    }

    static {
        ExprAnvilGuiOfPlayer.register(ExprAnvilGuiOfPlayer.class, AnvilGuiWrapper.class, (String)"(current[ly open]|open|top) [lusk] anvil[(-| )gui]", (String)"players");
    }
}

