/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.anvilgui.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.AnvilGuiWrapper;
import it.jakegblp.lusk.api.events.AnvilGuiSnapshotEvent;
import it.jakegblp.lusk.api.skript.PropertyExpression;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Anvil GUI - Text Input/Title")
@Description(value={"Gets the title and the text input of the provided anvil guis.\n*NOTES*:\n- These can be set.\n- To apply the changes you need to reopen the anvil gui to the player."})
@Examples(value={"set anvil gui text input of {_anvil} to \"Hello!!\""})
@Since(value={"1.3"})
public class ExprAnvilGuiTexts
extends PropertyExpression<AnvilGuiWrapper, String> {
    private boolean title;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.setExpr(expressions[0]);
        this.title = parseResult.hasTag("title");
        return true;
    }

    protected String @NotNull [] get(@NotNull Event event, AnvilGuiWrapper @NotNull [] source) {
        return (String[])this.get(source, anvilGuiWrapper -> {
            if (event instanceof AnvilGuiSnapshotEvent) {
                AnvilGuiSnapshotEvent snapshotEvent = (AnvilGuiSnapshotEvent)event;
                if (!this.title) {
                    return snapshotEvent.getText();
                }
            }
            return this.title ? anvilGuiWrapper.getTitle() : anvilGuiWrapper.getText();
        });
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public Class<?>[] acceptChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return new Class[]{String.class};
        }
        return null;
    }

    public void change(@NotNull Event event, Object @NotNull [] delta, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Object object;
        if (mode == Changer.ChangeMode.SET && (object = delta[0]) instanceof String) {
            String string = (String)object;
            this.getExpr().stream(event).forEach(anvilGuiWrapper -> {
                if (this.title) {
                    anvilGuiWrapper.setTitle(string);
                } else {
                    anvilGuiWrapper.setText(string);
                }
            });
        }
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "lusk anvil gui " + (this.title ? "title" : "text") + " of " + this.getExpr().toString(event, debug);
    }

    static {
        ExprAnvilGuiTexts.register(ExprAnvilGuiTexts.class, String.class, "[lusk] anvil[(-| )gui] ((rename|text) input|text|:title)", "anvilguiinventories");
    }
}

