/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blockface.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="BlockFace - Between Blocks")
@Description(value={"Returns the face relation of a block compared to another block.\n\nIf the blocks are not connected nothing will be returned.\n"})
@Examples(value={"set {_A} to block at location(10,10,10,\"world\")\nset {_B} to block at location(10,11,10,\"world\") # 1 block above\n\nset {_blockFace} to blockface from {_A} to {_B}\n\nbroadcast {_blockFace} # 'up face'\n"})
@Since(value={"1.2"})
public class ExprBlockFaceBetween
extends SimpleExpression<BlockFace> {
    Expression<Block> fromExpression;
    Expression<Block> toExpression;

    protected BlockFace @NotNull [] get(@NotNull Event event) {
        Block to;
        Block from = (Block)this.fromExpression.getSingle(event);
        if (from != null && (to = (Block)this.toExpression.getSingle(event)) != null) {
            return new BlockFace[]{from.getFace(to)};
        }
        return new BlockFace[0];
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends BlockFace> getReturnType() {
        return BlockFace.class;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "the blockface from " + this.fromExpression.toString(event, debug) + " to " + this.toExpression.toString(event, debug);
    }

    public boolean init(Expression<?>[] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.fromExpression = expressions[0];
        this.toExpression = expressions[1];
        return true;
    }

    static {
        Skript.registerExpression(ExprBlockFaceBetween.class, BlockFace.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] [block[ ]]face (from|between) %block% (to|and) %block%"});
    }
}

