/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.bell.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.BlockWrapper;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Bell - Resonating Time/Ticks")
@Description(value={"Returns the time or ticks since one or more bells have been resonating, or 0 seconds for each bell that's not currently resonating.\nA bell will typically resonate for 40 ticks (2 seconds)\n\nNote: if you wish to use this expression on Skript 2.9+ you will need to use Lusk 1.3+.\n"})
@Examples(value={"on bell ring:\n\twait 5 seconds\n\tbroadcast resonating time of event-block"})
@Since(value={"1.0.3, 1.3 (Ticks, BlockStates)"})
public class ExprBellResonatingTime
extends SimplePropertyExpression<Object, Object> {
    boolean useTicks;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.useTicks = parseResult.hasTag("ticks");
        return true;
    }

    @NotNull
    public Class<?> getReturnType() {
        return Object.class;
    }

    @Nullable
    public Object convert(Object o) {
        Integer ticks = new BlockWrapper(o).getBellResonatingTicks();
        return this.useTicks || ticks == null ? ticks : CompatibilityUtils.fromTicks(ticks.intValue());
    }

    @NotNull
    protected String getPropertyName() {
        return "resonating " + (this.useTicks ? "ticks" : "time");
    }

    static {
        ExprBellResonatingTime.register(ExprBellResonatingTime.class, Object.class, (String)"resonating (time|:ticks)", (String)"blocks/blockstates");
    }
}

