/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.block.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.BlockWrapper;
import org.jetbrains.annotations.NotNull;

@Name(value="Block - is Waterlogged")
@Description(value={"Checks whether or not one or more blocks, blockstates or blockdatas are waterlogged."})
@Examples(value={"if event-block is waterlogged:\n\tbroadcast \"%event-block% is waterlogged!\""})
@Since(value={"1.3"})
public class CondBlockIsWaterLogged
extends PropertyCondition<Object> {
    public boolean check(Object o) {
        return new BlockWrapper(o).isWaterLogged();
    }

    @NotNull
    protected String getPropertyName() {
        return "waterlogged";
    }

    static {
        CondBlockIsWaterLogged.register(CondBlockIsWaterLogged.class, (String)"water[ |-]logged", (String)"blocks/blockstates/blockdatas/itemtypes");
    }
}

