/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.block.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import it.jakegblp.lusk.api.BlockWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Block - Blast Resistance")
@Description(value={"Gets the blast resistance value (also known as block \"durability\").\nThis value is used in explosions to calculate whether a block should be broken or not.\n\nOnly works for placeable item/blocks.\n"})
@Examples(value={"broadcast blast resistance of obsidian"})
@Since(value={"1.0.0"})
public class ExprBlockBlastResistance
extends SimplePropertyExpression<Object, Float> {
    @NotNull
    public Class<? extends Float> getReturnType() {
        return Float.class;
    }

    @Nullable
    public Float convert(Object o) {
        return new BlockWrapper(o).getBlastResistance();
    }

    @NotNull
    protected String getPropertyName() {
        return "block blast resistance";
    }

    static {
        ExprBlockBlastResistance.register(ExprBlockBlastResistance.class, Float.class, (String)"[block] blast resistance", (String)"itemtypes/blocks/blockdatas/blockstates");
    }
}

