/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.block.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.paperlib.PaperLib;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.BlockWrapper;
import it.jakegblp.lusk.api.skript.SimplerPropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import it.jakegblp.lusk.utils.LuskUtils;
import org.jetbrains.annotations.Nullable;

@Name(value="Block - Liquid Level")
@Description(value={"Represents the maximum, minimum or current amount of fluid contained within a block, either by itself or inside a cauldron.\nMinimum Level requires Paper and 1.18.2.\n\nThis expression includes liquid blocks, cauldron and composters.\n\nFor water and lava blocks the levels have special meanings: a level of 0 corresponds to a source block, 1-7 regular fluid heights, and 8-15 to \"falling\" fluids.\nAll falling fluids have the same behaviour, but the level corresponds to that of the block above them, equal to this. level - 8\n\n**Note that counterintuitively, an adjusted level of 1 is the highest level, whilst 7 is the lowest.**\n\nMay not be higher than the max level.\n\nCan be set, added to, removed from and reset.\nReset requires Paper and 1.18.2.\n"})
@Examples(value={"broadcast max block level of event-block", "set block level of {_block} to 3"})
@Since(value={"1.3.2"})
public class ExprBlockLiquidLevel
extends SimplerPropertyExpression<Object, Integer> {
    Kleenean max;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.max = LuskUtils.getKleenean(parseResult.hasTag("max"), parseResult.hasTag("min"));
        return super.init(expressions, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Integer convert(Object from) {
        BlockWrapper blockWrapper = new BlockWrapper(from);
        return switch (this.max) {
            default -> throw new IncompatibleClassChangeError();
            case Kleenean.TRUE -> blockWrapper.getMaxLiquidLevel();
            case Kleenean.FALSE -> blockWrapper.getMinLiquidLevel();
            case Kleenean.UNKNOWN -> blockWrapper.getLiquidLevel();
        };
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowReset() {
        return PaperLib.isPaper();
    }

    @Override
    public boolean allowAdd() {
        return true;
    }

    @Override
    public boolean allowRemove() {
        return true;
    }

    @Override
    public void set(Object from, Integer to) {
        new BlockWrapper(from, true).setLiquidLevel(to);
    }

    @Override
    public void remove(Object from, Integer to) {
        this.add(from, -to.intValue());
    }

    @Override
    public void reset(Object from) {
        BlockWrapper blockWrapper = new BlockWrapper(from, true);
        blockWrapper.setLiquidLevel(blockWrapper.getMinLiquidLevel());
    }

    @Override
    public void add(Object from, Integer to) {
        BlockWrapper blockWrapper = new BlockWrapper(from, true);
        blockWrapper.setLiquidLevel(Math.min(blockWrapper.getLiquidLevel() + to, blockWrapper.getMaxLiquidLevel()));
    }

    protected String getPropertyName() {
        return (switch (this.max) {
            default -> throw new IncompatibleClassChangeError();
            case Kleenean.FALSE -> "min ";
            case Kleenean.UNKNOWN -> "";
            case Kleenean.TRUE -> "max ";
        }) + "block level";
    }

    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    static {
        ExprBlockLiquidLevel.register(ExprBlockLiquidLevel.class, Integer.class, (String)("[" + (Constants.PAPER_1_18_2 ? " (:max|:min)" : "max:max") + "[imum]] block [liquid] level"), (String)"blocks/itemtypes/blockdatas/blockstates");
    }
}

