/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.block.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.DocumentationId;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import it.jakegblp.lusk.api.BlockWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Block/BlockData/BlockState/Item - Slipperiness")
@Description(value={"Returns a value that represents how 'slippery' the block is.\nBlocks with higher slipperiness, like ice can be slid on further by the player and other entities.\nMost blocks have a default slipperiness of 0.6.\n\nCan be used with items, blocks, blockstates, and blockdatas.\n"})
@Examples(value={"broadcast slipperiness of packed ice"})
@Since(value={"1.0.0, 1.3 (Plural, Block, BlockData, BlockState)"})
@DocumentationId(value="8823")
public class ExprBlockSlipperiness
extends SimplePropertyExpression<Object, Float> {
    @NotNull
    public Class<? extends Float> getReturnType() {
        return Float.class;
    }

    @Nullable
    public Float convert(Object object) {
        return new BlockWrapper(object).getSlipperiness();
    }

    @NotNull
    protected String getPropertyName() {
        return "slipperiness";
    }

    static {
        ExprBlockSlipperiness.register(ExprBlockSlipperiness.class, Float.class, (String)"slipperiness", (String)"itemtypes/blocks/blockdatas/blockstates");
    }
}

