/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.block.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.bukkit.event.block.FluidLevelChangeEvent;
import org.jetbrains.annotations.Nullable;

@Name(value="Fluid Level Change Event - new Block Data")
@Description(value={"Can be set, reset and deleted.\nWhen set, the new blockdata must be of the same material as the one you're replacing;\nwhen reset and deleted, an empty blockdata of that material will be used."})
@Examples(value={"set new fluid level to water[level=3]"})
@Since(value={"1.3"})
public class ExprFluidLevelChangeNewBlockData
extends SimpleExpression<BlockData> {
    @Nullable
    protected BlockData[] get(Event event) {
        return new BlockData[]{((FluidLevelChangeEvent)event).getNewData()};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends BlockData> getReturnType() {
        return BlockData.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "the new fluid level block data";
    }

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        return this.getParser().isCurrentEvent(FluidLevelChangeEvent.class);
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class[] classArray;
        switch (mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case SET: {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = BlockData.class;
                break;
            }
            case DELETE: 
            case RESET: {
                classArray = new Class[]{};
                break;
            }
            case ADD: 
            case REMOVE: 
            case REMOVE_ALL: {
                classArray = null;
            }
        }
        return classArray;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (event instanceof FluidLevelChangeEvent) {
            BlockData blockData;
            Object object;
            FluidLevelChangeEvent fluidLevelChangeEvent = (FluidLevelChangeEvent)event;
            if (mode == Changer.ChangeMode.SET && delta != null && (object = delta[0]) instanceof BlockData && (blockData = (BlockData)object).getMaterial().equals((Object)fluidLevelChangeEvent.getNewData().getMaterial())) {
                fluidLevelChangeEvent.setNewData(blockData);
            } else if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
                fluidLevelChangeEvent.setNewData(Material.AIR.createBlockData());
            }
        }
    }

    static {
        Skript.registerExpression(ExprFluidLevelChangeNewBlockData.class, BlockData.class, (ExpressionType)Constants.EVENT_OR_SIMPLE, (String[])new String[]{"[the] [new] fluid level [block[ |-]]data"});
    }
}

