/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.block.types;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import it.jakegblp.lusk.api.skript.EnumRegistryWrapper;
import it.jakegblp.lusk.api.skript.EnumWrapper;
import org.bukkit.block.BlockState;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockIgniteEvent;
import org.jetbrains.annotations.NotNull;

public class BlockClassInfos {
    static {
        if (Classes.getExactClassInfo(BlockState.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(BlockState.class, "blockstate").user(new String[]{"block ?states?"}).name("BlockState").description(new String[]{"Represents a captured state of a block, which will not change automatically.\nUnlike Block, which only one object can exist per coordinate, BlockState can exist multiple times for any given Block. Note that another plugin may change the state of the block and you will not know, or they may change the block to another type entirely, causing your BlockState to become invalid.\n"}).since("1.3").parser((Parser)new Parser<BlockState>(){

                public boolean canParse(ParseContext context) {
                    return false;
                }

                @NotNull
                public String toString(BlockState blockState, int flags) {
                    return (blockState.isPlaced() ? "placed " : "") + "BlockState of type '" + String.valueOf(blockState.getType()) + "' at '" + String.valueOf(blockState.getLocation()) + "\"";
                }

                @NotNull
                public String toVariableNameString(BlockState blockState) {
                    return this.toString(blockState, 0);
                }
            }));
        }
        if (Classes.getExactClassInfo(BlockIgniteEvent.IgniteCause.class) == null) {
            Classes.registerClass((ClassInfo)new EnumRegistryWrapper(BlockIgniteEvent.IgniteCause.class, null, "ignition").getClassInfo("ignitecause").user(new String[]{"ignit(e|ion) ?causes?"}).name("Ignition Cause").description(new String[]{"All the Ignition Causes."}).since("1.3"));
        }
        if (Classes.getExactClassInfo(Action.class) == null) {
            EnumWrapper<Action> BLOCK_ACTION_ENUM = new EnumWrapper<Action>(Action.class);
            Classes.registerClass((ClassInfo)BLOCK_ACTION_ENUM.getClassInfo("blockaction").user(new String[]{"block ?actions?"}).name("Block Action").description(new String[]{"All the Block Actions."}).examples(new String[]{"physical", "left click air"}).since("1.3"));
        }
    }
}

