/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.brewingstand.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.BlockWrapper;
import it.jakegblp.lusk.api.skript.SimplerPropertyExpression;
import org.jetbrains.annotations.Nullable;

@Name(value="BrewingStand - Fuel Item")
@Description(value={"Returns the brewing fuel item of a Brewing Stand.\nCan be set."})
@Examples(value={"on brewing start:\n\tbroadcast the brewing fuel of event-block"})
@Since(value={"1.0.2, 1.3 (Plural, Blockstate, Item)"})
public class ExprBrewingFuel
extends SimplerPropertyExpression<Object, ItemType> {
    @Nullable
    public ItemType convert(Object from) {
        return new BlockWrapper(from).getBrewingFuel();
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowDelete() {
        return true;
    }

    @Override
    public void set(Object from, ItemType to) {
        new BlockWrapper(from, true).setBrewingFuel(to);
    }

    @Override
    public void delete(Object from) {
        this.set(from, null);
    }

    protected String getPropertyName() {
        return "brewing fuel item";
    }

    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    static {
        ExprBrewingFuel.register(ExprBrewingFuel.class, ItemType.class, (String)"brewing fuel [item]", (String)"blocks/blockstates/itemtypes");
    }
}

