/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.cauldron.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.event.Event;
import org.bukkit.event.block.CauldronLevelChangeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Cauldron - Change Reason")
@Description(value={"Returns the Change Reason in a Cauldron Level Change Event."})
@Examples(value={"on cauldron level change:\n\tbroadcast the cauldron change reason"})
@Since(value={"1.0.2"})
public class ExprCauldronChangeReason
extends SimpleExpression<CauldronLevelChangeEvent.ChangeReason> {
    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent(CauldronLevelChangeEvent.class)) {
            Skript.error((String)"This expression can only be used in the Cauldron Level Change Event!");
            return false;
        }
        return true;
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    CauldronLevelChangeEvent.ChangeReason @NotNull [] get(@NotNull Event e) {
        return new CauldronLevelChangeEvent.ChangeReason[]{((CauldronLevelChangeEvent)e).getReason()};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends CauldronLevelChangeEvent.ChangeReason> getReturnType() {
        return CauldronLevelChangeEvent.ChangeReason.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "the cauldron change reason";
    }

    static {
        Skript.registerExpression(ExprCauldronChangeReason.class, CauldronLevelChangeEvent.ChangeReason.class, (ExpressionType)Constants.EVENT_OR_SIMPLE, (String[])new String[]{"(the |event-)cauldron change reason"});
    }
}

