/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.composter.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import io.papermc.paper.event.block.CompostItemEvent;
import io.papermc.paper.event.entity.EntityCompostItemEvent;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Will Raise Composter Level")
@Description(value={"This Condition requires Paper.\n\nChecks whether or not the composter's level will rise in a Compost Item Event"})
@Examples(value={"on hopper compost:\n  if the composter level will be raised:\n    cancel composter rise\n"})
@Since(value={"1.0.0"})
@RequiredPlugins(value={"Paper"})
public class CondRiseComposterLevel
extends Condition {
    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parser) {
        if (!this.getParser().isCurrentEvent(new Class[]{CompostItemEvent.class, EntityCompostItemEvent.class})) {
            Skript.error((String)"This condition can only be used in the Hopper Compost event!");
            return false;
        }
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "the composter level will " + (this.isNegated() ? "not" : "") + " be raised";
    }

    public boolean check(@NotNull Event event) {
        if (event instanceof EntityCompostItemEvent) {
            EntityCompostItemEvent entityCompostItemEvent = (EntityCompostItemEvent)event;
            return this.isNegated() ^ entityCompostItemEvent.willRaiseLevel();
        }
        return this.isNegated() ^ ((CompostItemEvent)event).willRaiseLevel();
    }

    static {
        if (Skript.classExists((String)"io.papermc.paper.event.block.CompostItemEvent")) {
            Skript.registerCondition(CondRiseComposterLevel.class, (String[])new String[]{"[the] composter level will be raised", "[the] composter level w(ill no|on')t be raised"});
        }
    }
}

