/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.hopper.events;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.HopperInventorySearchEvent;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvtHopperInventorySearch
extends SkriptEvent {
    private int pattern;

    public boolean init(Literal<?> @NotNull [] args, int matchedPattern, @NotNull SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        return true;
    }

    public boolean check(@NotNull Event e) {
        if (this.pattern == 1) {
            return ((HopperInventorySearchEvent)e).getContainerType() == HopperInventorySearchEvent.ContainerType.SOURCE;
        }
        if (this.pattern == 2) {
            return ((HopperInventorySearchEvent)e).getContainerType() == HopperInventorySearchEvent.ContainerType.DESTINATION;
        }
        return true;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "hopper " + (switch (this.pattern) {
            case 1 -> "source";
            case 2 -> "destination";
            default -> "inventory";
        }) + " search";
    }

    static {
        if (Constants.HAS_HOPPER_INVENTORY_SEARCH_EVENT) {
            Skript.registerEvent((String)"Hopper - on Inventory Search", EvtHopperInventorySearch.class, HopperInventorySearchEvent.class, (String[])new String[]{"hopper inventory search[ing]", "hopper source search[ing]", "hopper destination search[ing]"}).description(new String[]{"Called each time a Hopper attempts to find its source/attached containers."}).examples(new String[]{"on hopper inventory search:\n\tbroadcast event-inventory"}).since("1.0.4");
            CompatibilityUtils.registerEventValue(HopperInventorySearchEvent.class, Inventory.class, HopperInventorySearchEvent::getInventory, 0);
        }
    }
}

