/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.loom.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.papermc.paper.event.player.PlayerLoomPatternSelectEvent;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.block.banner.PatternType;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Loom Pattern Type")
@Description(value={"Gets the pattern type selected in a Loom Pattern Select event"})
@Examples(value={"on pattern select of border:\n  set the loom pattern to creeper\n\non pattern select:\n  broadcast loom pattern\n\non pattern select of bricks:\n  broadcast the selected loom pattern\n"})
@Since(value={"1.0.0"})
@RequiredPlugins(value={"Paper"})
public class ExprLoomPatternType
extends SimpleExpression<PatternType> {
    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent(PlayerLoomPatternSelectEvent.class)) {
            Skript.error((String)"This expression can only be used in the Loom Pattern Select Event!");
            return false;
        }
        return true;
    }

    protected PatternType @NotNull [] get(@NotNull Event e) {
        return new PatternType[]{((PlayerLoomPatternSelectEvent)e).getPatternType()};
    }

    public Class<?>[] acceptChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Class[] classArray;
        if (mode == Changer.ChangeMode.SET) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = PatternType.class;
        } else {
            classArray = null;
        }
        return classArray;
    }

    public void change(@NotNull Event e, Object @NotNull [] delta, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Object object = delta[0];
        if (object instanceof PatternType) {
            PatternType patternType = (PatternType)object;
            ((PlayerLoomPatternSelectEvent)e).setPatternType(patternType);
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends PatternType> getReturnType() {
        return PatternType.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "the selected loom banner pattern type";
    }

    static {
        if (Skript.classExists((String)"io.papermc.paper.event.player.PlayerLoomPatternSelectEvent")) {
            Skript.registerExpression(ExprLoomPatternType.class, PatternType.class, (ExpressionType)Constants.EVENT_OR_SIMPLE, (String[])new String[]{"[the] [selected] loom [banner] pattern [type]"});
        }
    }
}

