/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.boundingbox.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import org.bukkit.event.Event;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Bounding Box - Overlaps")
@Description(value={"Whether or not one or more bounding boxes overlap other bounding boxes.\nBounding boxes that are only intersecting at the borders are not considered overlapping."})
@Examples(value={"if {_box} overlaps bounding box of player:"})
@Since(value={"1.3"})
public class CondBoundingBoxOverlaps
extends Condition {
    private Expression<BoundingBox> boundingBox1;
    private Expression<BoundingBox> boundingBox2;

    public boolean init(Expression<?>[] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.boundingBox1 = expressions[0];
        this.boundingBox2 = expressions[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(@NotNull Event event) {
        return CompatibilityUtils.test(this.boundingBox1, event, box1 -> CompatibilityUtils.test(this.boundingBox2, event, arg_0 -> ((BoundingBox)box1).overlaps(arg_0)), this.isNegated());
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return this.boundingBox1.toString(event, debug) + (this.isNegated() ? " don't overlap " : " overlap ") + this.boundingBox2.toString(event, debug);
    }

    static {
        Skript.registerCondition(CondBoundingBoxOverlaps.class, (String[])new String[]{"%boundingboxes% overlap[s] [with] [[bounding[ ]]box] %boundingboxes%", "%boundingboxes% do[es](n't| not) overlap [with] [[bounding[ ]]box] %boundingboxes%"});
    }
}

