/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.boundingbox.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Bounding Box - X is Within")
@Description(value={"Whether or not a Vector, Location, or Bounding Box is within a Bounding Box.\n\nVector and Location = Checks if the Bounding Box contains a specified position.\nBounding Box = Checks if the Bounding Box fully contains a Bounding Box."})
@Examples(value={"if location of player is within bounding box of player:"})
@Since(value={"1.2"})
public class CondBoundingBoxWithin
extends Condition {
    private Expression<Object> objects;
    private Expression<BoundingBox> boundingBoxes;

    public boolean init(Expression<?>[] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.objects = expressions[0];
        this.boundingBoxes = expressions[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(@NotNull Event event) {
        return CompatibilityUtils.test(this.boundingBoxes, event, boundingBox -> CompatibilityUtils.test(this.objects, event, object -> {
            if (object instanceof Vector) {
                Vector vector = (Vector)object;
                return boundingBox.contains(vector);
            }
            if (object instanceof Location) {
                Location location = (Location)object;
                return boundingBox.contains(location.toVector());
            }
            if (object instanceof BoundingBox) {
                BoundingBox box = (BoundingBox)object;
                return boundingBox.contains(box);
            }
            return false;
        }), this.isNegated());
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return this.objects.toString(event, debug) + " is " + (this.isNegated() ? "not" : "") + " within " + this.boundingBoxes.toString(event, debug);
    }

    static {
        Skript.registerCondition(CondBoundingBoxWithin.class, (String[])new String[]{"%vectors/locations/boundingboxes% (is|are) (within|in[side [of]]) [[bounding[ ]]box] %boundingbox%", "%vectors/locations/boundingboxes% (isn't|is not|aren't|are not) (within|in[side [of]]) [[bounding[ ]]box] %boundingbox%"});
    }
}

