/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.boundingbox.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.skript.PropertyExpression;
import org.bukkit.Axis;
import org.bukkit.event.Event;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Bounding Box - Corners/Center Coordinates")
@Description(value={"Gets the x,y or z coordinate for the lesser corner, the greater corner or the center of one or more bounding boxes."})
@Examples(value={"broadcast box lesser x-loc of target"})
@Since(value={"1.3"})
public class ExprBoundingBoxCoordinates
extends PropertyExpression<BoundingBox, Double> {
    @Nullable
    Boolean state;
    Axis coordinate;

    public boolean init(Expression<?>[] vars, int matchedPattern, @NotNull Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.setExpr(vars[0]);
        Boolean bl = parser.hasTag("lesser") ? Boolean.FALSE : (this.state = parser.hasTag("greater") ? Boolean.valueOf(true) : null);
        this.coordinate = parser.hasTag("x") ? Axis.X : (parser.hasTag("y") ? Axis.Y : Axis.Z);
        return true;
    }

    @NotNull
    public Class<Double> getReturnType() {
        return Double.class;
    }

    protected Double @NotNull [] get(@NotNull Event e, BoundingBox @NotNull [] source) {
        return (Double[])this.get(source, box -> {
            double d;
            if (this.state == null) {
                switch (this.coordinate) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case X: {
                        d = box.getCenterX();
                        break;
                    }
                    case Y: {
                        d = box.getCenterY();
                        break;
                    }
                    case Z: {
                        d = box.getCenterZ();
                        break;
                    }
                }
            } else if (this.state.booleanValue()) {
                switch (this.coordinate) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case X: {
                        d = box.getMaxX();
                        break;
                    }
                    case Y: {
                        d = box.getMaxY();
                        break;
                    }
                    case Z: {
                        d = box.getMaxZ();
                        break;
                    }
                }
            } else {
                switch (this.coordinate) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case X: {
                        d = box.getMinX();
                        break;
                    }
                    case Y: {
                        d = box.getMinY();
                        break;
                    }
                    case Z: {
                        d = box.getMinZ();
                    }
                }
            }
            return d;
        });
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "bounding box " + (this.state == null ? "center" : (this.state != false ? "greater" : "lesser")) + String.valueOf(this.coordinate) + "-coordinate of " + this.getExpr().toString(event, debug);
    }

    static {
        Skript.registerExpression(ExprBoundingBoxCoordinates.class, Double.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] [bounding[ ]]box (:lesser|:greater|center) (:x|:y|z)(-loc|(-| )coord[inate]) of %boundingboxes%", "%boundingboxes%'[s] [bounding[ ]]box (:lesser|:greater|center) (:x|:y|z)(-loc|(-| )coord[inate])"});
    }
}

