/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.boundingbox.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.skript.PropertyExpression;
import org.bukkit.event.Event;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Bounding Box - Corners/Center")
@Description(value={"Gets either the lesser or the greater corner or the lesser of one or more bounding boxes.\n\nReturns vectors."})
@Examples(value={"broadcast box lesser corner of bounding box of target", "send box greater corner of {_box}"})
@Since(value={"1.3"})
public class ExprBoundingBoxLocations
extends PropertyExpression<BoundingBox, Vector> {
    @Nullable
    Boolean state;

    public boolean init(Expression<?>[] vars, int matchedPattern, @NotNull Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.setExpr(vars[0]);
        this.state = parser.hasTag("center") ? null : Boolean.valueOf(parser.hasTag("greater"));
        return true;
    }

    @NotNull
    public Class<Vector> getReturnType() {
        return Vector.class;
    }

    protected Vector @NotNull [] get(@NotNull Event e, BoundingBox @NotNull [] source) {
        return (Vector[])this.get(source, box -> {
            if (this.state == null) {
                return box.getCenter();
            }
            if (this.state.booleanValue()) {
                return box.getMax();
            }
            return box.getMin();
        });
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        StringBuilder builder = new StringBuilder("the bounding box ");
        if (this.state == null) {
            builder.append("center");
        } else {
            if (this.state.booleanValue()) {
                builder.append("greater");
            } else {
                builder.append("lesser");
            }
            builder.append(" corner");
        }
        return builder.append(" of ").append(this.getExpr().toString(event, debug)).toString();
    }

    static {
        Skript.registerExpression(ExprBoundingBoxLocations.class, Vector.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] [bounding[ ]]box (center:cent(er|re)|(:greater|lesser) corner) of %boundingboxes%", "%boundingboxes%'[s] [bounding[ ]]box (center:cent(er|re)|(:greater|lesser) corner)"});
    }
}

