/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.boundingbox.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Bounding Box - of Entity/Block")
@Description(value={"Returns the bounding box of a block or an entity which reflects its location and size. (But not its world, kind of like vectors)"})
@Examples(value={"broadcast bounding box of target"})
@Since(value={"1.0.2, 1.2 (Blocks), 1.3 (BlockStates)"})
public class ExprBoundingBoxOf
extends SimplePropertyExpression<Object, BoundingBox> {
    @Nullable
    public BoundingBox convert(Object from) {
        if (from instanceof Entity) {
            Entity entity = (Entity)from;
            return entity.getBoundingBox();
        }
        if (from instanceof BlockState) {
            BlockState blockState = (BlockState)from;
            return blockState.getBlock().getBoundingBox();
        }
        if (from instanceof Block) {
            Block block = (Block)from;
            return block.getBoundingBox();
        }
        return null;
    }

    @NotNull
    protected String getPropertyName() {
        return "bounding box";
    }

    @NotNull
    public Class<? extends BoundingBox> getReturnType() {
        return BoundingBox.class;
    }

    static {
        ExprBoundingBoxOf.register(ExprBoundingBoxOf.class, BoundingBox.class, (String)"bounding box", (String)"entities/blocks");
    }
}

