/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.boundingbox.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.skript.PropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Bounding Box - of Voxel Shape")
@Description(value={"Converts shapes into a collection of Bounding Boxes equivalent to the shape they come from."})
@Examples(value={"broadcast bounding boxes of {_voxelShape}"})
@Since(value={"1.2"})
@RequiredPlugins(value={"1.17"})
public class ExprBoundingBoxesOfVoxelShape
extends PropertyExpression<VoxelShape, BoundingBox> {
    public boolean init(Expression<?>[] vars, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parser) {
        this.setExpr(vars[0]);
        return true;
    }

    @NotNull
    public Class<BoundingBox> getReturnType() {
        return BoundingBox.class;
    }

    protected BoundingBox[] get(Event e, VoxelShape[] source) {
        VoxelShape[] voxelShapes = (VoxelShape[])this.getExpr().getArray(e);
        ArrayList boundingBoxList = new ArrayList();
        for (VoxelShape voxelShape : voxelShapes) {
            boundingBoxList.addAll(voxelShape.getBoundingBoxes());
        }
        return boundingBoxList.toArray(new BoundingBox[0]);
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "the bounding boxes of " + this.getExpr().toString(event, debug);
    }

    static {
        if (Constants.HAS_VOXEL_SHAPE) {
            Skript.registerExpression(ExprBoundingBoxesOfVoxelShape.class, BoundingBox.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] bounding boxes of %voxelshapes%", "%voxelshapes%'[s] bounding boxes"});
        }
    }
}

