/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.boundingbox.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Bounding Box - New Bounding Box")
@Description(value={"Creates a new empty Bounding Box, one from two corners or a copy of a given bounding box"})
@Examples(value={"broadcast a new empty bounding box"})
@Since(value={"1.2, 1.3 (Copy)"})
public class ExprNewBoundingBox
extends SimpleExpression<BoundingBox> {
    private boolean empty;
    private Expression<Object> objectExpression1;
    private Expression<Object> objectExpression2 = null;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        boolean bl = this.empty = matchedPattern == 0;
        if (!this.empty) {
            this.objectExpression1 = expressions[0];
            if (matchedPattern != 2) {
                this.objectExpression2 = expressions[1];
            }
        }
        return true;
    }

    protected BoundingBox @NotNull [] get(@NotNull Event event) {
        Vector v2;
        Vector v1;
        if (this.empty) {
            return new BoundingBox[]{new BoundingBox()};
        }
        Object o1 = this.objectExpression1.getSingle(event);
        if (o1 instanceof BoundingBox) {
            BoundingBox boundingBox = (BoundingBox)o1;
            return new BoundingBox[]{boundingBox.clone()};
        }
        Object o2 = this.objectExpression2.getSingle(event);
        if (o1 instanceof Location) {
            Location location = (Location)o1;
            v0 = location.toVector();
        } else {
            Vector vector;
            v0 = v1 = o1 instanceof Vector ? (vector = (Vector)o1) : null;
        }
        if (o2 instanceof Location) {
            Location location = (Location)o2;
            v1 = location.toVector();
        } else {
            Vector vector;
            v1 = v2 = o2 instanceof Vector ? (vector = (Vector)o2) : null;
        }
        if (v1 != null && v2 != null) {
            return new BoundingBox[]{new BoundingBox(v1.getX(), v1.getY(), v1.getZ(), v2.getX(), v2.getY(), v2.getZ())};
        }
        return new BoundingBox[0];
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<BoundingBox> getReturnType() {
        return BoundingBox.class;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        if (this.empty) {
            return "a new empty bounding box";
        }
        if (this.objectExpression2 == null) {
            return "a new bounding box from " + this.objectExpression1.toString(event, debug);
        }
        return "a new bounding box from " + this.objectExpression1.toString(event, debug) + " and " + this.objectExpression2.toString(event, debug);
    }

    static {
        Skript.registerExpression(ExprNewBoundingBox.class, BoundingBox.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a[n]] (new|[new] empty) bounding box", "[a] [new] bounding box (between|from|using|with) %vector/location% (,|[,] and|to) %vector/location%", "[a] [new [cloned|copied]|cloned|copied] bounding box from %boundingbox%"});
    }
}

