/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.boundingbox.types;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import ch.njol.yggdrasil.Fields;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import it.jakegblp.lusk.utils.Constants;
import it.jakegblp.lusk.utils.LuskUtils;
import java.io.StreamCorruptedException;
import java.util.stream.Collectors;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.generator.structure.GeneratedStructure;
import org.bukkit.generator.structure.StructurePiece;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoundingBoxClassInfos {
    static {
        if (Classes.getExactClassInfo(BoundingBox.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(BoundingBox.class, "boundingbox").user(new String[]{"bounding ?box(es)?"}).name("Bounding Box").description(new String[]{"A Bounding Box.\n\nPersistent in global variables since 1.2."}).since("1.0.2, 1.2 (Variables)").documentationId("9096").parser((Parser)new Parser<BoundingBox>(){

                @Nullable
                public BoundingBox parse(@NotNull String s, @NotNull ParseContext context) {
                    return null;
                }

                public boolean canParse(@NotNull ParseContext context) {
                    return false;
                }

                @NotNull
                public String toString(BoundingBox b, int flags) {
                    return LuskUtils.toSkriptConfigNumberAccuracy(b.toString());
                }

                @NotNull
                public String toVariableNameString(BoundingBox b) {
                    return b.toString();
                }

                @NotNull
                public String getDebugMessage(BoundingBox b) {
                    return this.toString(b, 0) + " bounding box (" + String.valueOf(b) + ")";
                }
            }).serializer((Serializer)new Serializer<BoundingBox>(){

                @NotNull
                public Fields serialize(BoundingBox o) {
                    Fields f = new Fields();
                    f.putPrimitive("minX", (Object)o.getMinX());
                    f.putPrimitive("minY", (Object)o.getMinY());
                    f.putPrimitive("minZ", (Object)o.getMinZ());
                    f.putPrimitive("maxX", (Object)o.getMaxX());
                    f.putPrimitive("maxY", (Object)o.getMaxY());
                    f.putPrimitive("maxZ", (Object)o.getMaxZ());
                    return f;
                }

                public void deserialize(BoundingBox o, @NotNull Fields f) {
                    assert (false);
                }

                protected BoundingBox deserialize(@NotNull Fields f) throws StreamCorruptedException {
                    return new BoundingBox(((Double)f.getPrimitive("minX", Double.TYPE)).doubleValue(), ((Double)f.getPrimitive("minY", Double.TYPE)).doubleValue(), ((Double)f.getPrimitive("minZ", Double.TYPE)).doubleValue(), ((Double)f.getPrimitive("maxX", Double.TYPE)).doubleValue(), ((Double)f.getPrimitive("maxY", Double.TYPE)).doubleValue(), ((Double)f.getPrimitive("maxZ", Double.TYPE)).doubleValue());
                }

                public boolean mustSyncDeserialization() {
                    return true;
                }

                protected boolean canBeInstantiated() {
                    return false;
                }
            }));
            CompatibilityUtils.registerConverter(Block.class, BoundingBox.class, Block::getBoundingBox);
            CompatibilityUtils.registerConverter(Entity.class, BoundingBox.class, Entity::getBoundingBox);
            if (Constants.HAS_STRUCTURE_PIECE) {
                CompatibilityUtils.registerConverter(StructurePiece.class, BoundingBox.class, StructurePiece::getBoundingBox);
            }
            if (Constants.HAS_GENERATED_STRUCTURE) {
                CompatibilityUtils.registerConverter(GeneratedStructure.class, BoundingBox.class, GeneratedStructure::getBoundingBox);
            }
        }
        if (Constants.HAS_VOXEL_SHAPE && Classes.getExactClassInfo(VoxelShape.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(VoxelShape.class, "voxelshape").user(new String[]{"voxel ?shapes?"}).name("Voxel Shape").description(new String[]{"A Voxel Shape, usually used for blocks such as Stairs.\n\nYou can store those but it's not persistent across restarts."}).since("1.2").parser((Parser)new Parser<VoxelShape>(){

                @Nullable
                public VoxelShape parse(@NotNull String s, @NotNull ParseContext context) {
                    return null;
                }

                public boolean canParse(@NotNull ParseContext context) {
                    return false;
                }

                @NotNull
                public String toString(VoxelShape s, int flags) {
                    return "VoxelShape [" + s.getBoundingBoxes().stream().map(box -> LuskUtils.toSkriptConfigNumberAccuracy(box.toString())).collect(Collectors.joining(", ")) + "]";
                }

                @NotNull
                public String toVariableNameString(VoxelShape s) {
                    return s.toString();
                }

                @NotNull
                public String getDebugMessage(VoxelShape s) {
                    return this.toString(s, 0) + " voxel shape (" + String.valueOf(s) + ")";
                }
            }));
        }
    }
}

