/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.enchantment.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.enchantments.Enchantment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Enchantment - Minimum Level")
@Description(value={"Returns the Minimum Vanilla Level for an Enchantment."})
@Examples(value={"broadcast minimum enchantment level of protection"})
@Since(value={"1.0.0"})
public class ExprMinEnchantLevel
extends SimplePropertyExpression<Enchantment, Integer> {
    @NotNull
    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    @Nullable
    public Integer convert(Enchantment enchantment) {
        return enchantment.getStartLevel();
    }

    @NotNull
    protected String getPropertyName() {
        return "vanilla minimum enchantment level";
    }

    static {
        ExprMinEnchantLevel.register(ExprMinEnchantLevel.class, Integer.class, (String)"[vanilla] min[imum] enchant[ment] level", (String)"enchantments");
    }
}

