/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.allay.conditions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.ExtendedPropertyType;
import it.jakegblp.lusk.api.skript.PrefixedPropertyCondition;
import org.bukkit.entity.Allay;
import org.bukkit.entity.Entity;

@Name(value="Allay - can Be Duplicated")
@Description(value={"Checks if an allay can be duplicated."})
@Examples(value={"if target can be duplicated:"})
@Since(value={"1.0.2, 1.3 (Plural)"})
public class CondAllayCanBeDuplicated
extends PrefixedPropertyCondition<Entity> {
    public boolean check(Entity value) {
        Allay allay;
        return value instanceof Allay && (allay = (Allay)value).canDuplicate();
    }

    protected String getPropertyName() {
        return "be duplicated";
    }

    @Override
    public String getPrefix() {
        return "allays";
    }

    static {
        CondAllayCanBeDuplicated.register(CondAllayCanBeDuplicated.class, ExtendedPropertyType.CAN, "[allay[s]]", "be duplicated", "entities");
    }
}

