/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.allay.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Allay;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Allay - Start/Stop Dance")
@Description(value={"Forces an Allay to start/stop dancing."})
@Examples(value={"make target start dancing"})
@Since(value={"1.0.2"})
public class EffAllayDance
extends Effect {
    private Expression<LivingEntity> entityExpression;
    private boolean stop;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parser) {
        this.stop = parser.hasTag("stop");
        this.entityExpression = expressions[0];
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "make " + this.entityExpression.toString(event, debug) + (this.stop ? " stop" : " start") + " dancing";
    }

    protected void execute(@NotNull Event event) {
        LivingEntity[] entities;
        for (LivingEntity entity : entities = (LivingEntity[])this.entityExpression.getArray(event)) {
            if (!(entity instanceof Allay)) continue;
            Allay allay = (Allay)entity;
            if (this.stop) {
                allay.stopDancing();
                continue;
            }
            allay.startDancing();
        }
    }

    static {
        Skript.registerEffect(EffAllayDance.class, (String[])new String[]{"make %livingentities% (start|:stop) dancing"});
    }
}

