/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.allay.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Allay;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Allay - Duplicate")
@Description(value={"Forces an allay to duplicate itself without dance or item necessary."})
@Examples(value={"force duplicate (entities where [input is an allay])"})
@Since(value={"1.0.2"})
public class EffAllayDuplicate
extends Effect {
    private Expression<LivingEntity> entityExpression;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parser) {
        this.entityExpression = expressions[0];
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "force duplicate " + this.entityExpression.toString(event, debug);
    }

    protected void execute(@NotNull Event event) {
        LivingEntity[] entities;
        for (LivingEntity entity : entities = (LivingEntity[])this.entityExpression.getArray(event)) {
            if (!(entity instanceof Allay)) continue;
            Allay allay = (Allay)entity;
            allay.duplicateAllay();
        }
    }

    static {
        Skript.registerEffect(EffAllayDuplicate.class, (String[])new String[]{"[force] duplicate %livingentities%"});
    }
}

