/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.allay.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import org.bukkit.entity.Allay;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Allay - Duplication Cooldown")
@Description(value={"Returns the duplication cooldown of an Allay.\nCan be set."})
@Examples(value={"broadcast duplication cooldown of target"})
@Since(value={"1.0.2, 1.3 (Plural, Ticks)"})
public class ExprAllayDuplicationCooldown
extends SimplePropertyExpression<LivingEntity, Object> {
    private boolean usesTicks;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.usesTicks = parseResult.hasTag("ticks");
        return super.init(expressions, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Object convert(LivingEntity from) {
        if (from instanceof Allay) {
            Allay allay = (Allay)from;
            long ticks = allay.getDuplicationCooldown();
            return this.usesTicks ? Long.valueOf(ticks) : CompatibilityUtils.fromTicks(ticks);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        long ticks;
        if (delta == null) {
            if (mode != Changer.ChangeMode.RESET) return;
            ticks = 0L;
        } else {
            if (delta.length < 1) {
                return;
            }
            Object object = delta[0];
            if (object instanceof Number) {
                Number number = (Number)object;
                ticks = number.longValue();
            } else {
                object = delta[0];
                if (!(object instanceof Timespan)) return;
                Timespan timespan = (Timespan)object;
                ticks = CompatibilityUtils.getTicks(timespan);
            }
        }
        block5: for (LivingEntity entity : (LivingEntity[])this.getExpr().getAll(event)) {
            if (!(entity instanceof Allay)) continue;
            Allay allay = (Allay)entity;
            switch (mode) {
                case REMOVE: {
                    allay.setDuplicationCooldown(allay.getDuplicationCooldown() - ticks);
                    continue block5;
                }
                case ADD: {
                    allay.setDuplicationCooldown(allay.getDuplicationCooldown() + ticks);
                    continue block5;
                }
                case SET: 
                case RESET: {
                    allay.setDuplicationCooldown(ticks);
                }
            }
        }
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class[] classArray;
        switch (mode) {
            case REMOVE: 
            case ADD: 
            case SET: {
                Class[] classArray2 = new Class[2];
                classArray2[0] = Timespan.class;
                classArray = classArray2;
                classArray2[1] = Long.class;
                break;
            }
            case RESET: {
                classArray = new Class[]{};
                break;
            }
            default: {
                classArray = null;
            }
        }
        return classArray;
    }

    protected String getPropertyName() {
        return "allay duplication cooldown " + (this.usesTicks ? "ticks" : "timespan");
    }

    public Class<?> getReturnType() {
        return this.usesTicks ? Long.class : Timespan.class;
    }

    static {
        ExprAllayDuplicationCooldown.register(ExprAllayDuplicationCooldown.class, Object.class, (String)"allay duplication cooldown [time[span]|:ticks]", (String)"livingentities");
    }
}

