/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.armorstand.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlot;
import org.jetbrains.annotations.Nullable;

@Name(value="Armor Stand - is Equipment Slot Disabled")
@Description(value={"Checks if a specific equipment slot of an armorstand is disabled."})
@Examples(value={"if chest slot is disabled for {_armorStand}:"})
@Since(value={"1.3"})
public class CondEquipmentSlotDisabledArmorStand
extends Condition {
    private Expression<EquipmentSlot> equipmentSlotExpression;
    private Expression<LivingEntity> livingEntityExpression;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.equipmentSlotExpression = expressions[0];
        this.livingEntityExpression = expressions[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(Event event) {
        return CompatibilityUtils.test(this.livingEntityExpression, event, livingEntity -> {
            if (!(livingEntity instanceof ArmorStand)) return false;
            ArmorStand armorStand = (ArmorStand)livingEntity;
            if (!CompatibilityUtils.test(this.equipmentSlotExpression, event, arg_0 -> ((ArmorStand)armorStand).isSlotDisabled(arg_0))) return false;
            return true;
        }, this.isNegated());
    }

    public String toString(@Nullable Event event, boolean debug) {
        return this.equipmentSlotExpression.toString(event, debug) + " are " + (this.isNegated() ? "not " : "") + "disabled for " + this.livingEntityExpression.toString(event, debug);
    }

    static {
        Skript.registerCondition(CondEquipmentSlotDisabledArmorStand.class, (String[])new String[]{"%equipmentslots% (is|are) disabled (on|for) %livingentities%", "%equipmentslots% (isn't|is not|aren't|are not) disabled (on|for) %livingentities%"});
    }
}

