/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.armorstand.events;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import it.jakegblp.lusk.api.enums.ArmorStandInteraction;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import it.jakegblp.lusk.utils.EventUtils;
import java.util.Arrays;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvtArmorStandManipulate
extends SkriptEvent {
    private Literal<EquipmentSlot> slots;
    private Literal<ArmorStandInteraction> interactionLiteral;

    public boolean init(Literal @NotNull [] args, int matchedPattern, @NotNull SkriptParser.ParseResult parseResult) {
        this.slots = args[0];
        this.interactionLiteral = args[1];
        List<ArmorStandInteraction> list = Arrays.stream((ArmorStandInteraction[])this.interactionLiteral.getAll()).toList();
        if (list.contains((Object)ArmorStandInteraction.CHANGE) && list.size() > 1) {
            Skript.warning((String)"The generic interaction type covers all cases, the rest of the interactions added here are redundant.");
        }
        return true;
    }

    public boolean check(@NotNull Event event) {
        PlayerArmorStandManipulateEvent armorStandManipulateEvent = (PlayerArmorStandManipulateEvent)event;
        boolean toolIsAir = armorStandManipulateEvent.getPlayerItem().getType().isAir();
        boolean equippedIsAir = armorStandManipulateEvent.getArmorStandItem().getType().isAir();
        List<ArmorStandInteraction> list = Arrays.stream((ArmorStandInteraction[])this.interactionLiteral.getAll()).toList();
        if (list.contains((Object)ArmorStandInteraction.CHANGE) || list.contains((Object)EventUtils.getInteraction(armorStandManipulateEvent))) {
            return this.slots == null || CompatibilityUtils.test(this.slots, (Event)armorStandManipulateEvent, slot -> slot.equals((Object)armorStandManipulateEvent.getSlot()));
        }
        return false;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "armor stand " + (this.slots != null ? this.slots.toString(e, debug) : "") + " " + (this.interactionLiteral != null ? this.interactionLiteral.toString(e, debug) : "");
    }

    static {
        if (Skript.classExists((String)"org.bukkit.event.player.PlayerArmorStandManipulateEvent")) {
            Skript.registerEvent((String)"Armor Stand - on Manipulate", EvtArmorStandManipulate.class, PlayerArmorStandManipulateEvent.class, (String[])new String[]{"armor[ |-]stand [%-*equipmentslots%] %*armorstandinteractions%"}).description(new String[]{"Called when a player interacts with an armor stand and will either swap, retrieve, place an item.\n\n`event-equipmentslot` is the clicked slot of the armor stand, to get the hand use the Used Hand expression\n`event-entity` is the armor stand\n\n`past event-item` is the item the armor stand is holding\n`future event-item` (or `event-item`) is the item the player is holding\n\n`event-armorstand interaction` is the type of manipulation that's happening during the event\n(NOTE: this will only ever return `Place`, `Retrieve` or `Change`)\n"}).examples(new String[]{"on armor stand chest slot retrieve;\n    broadcast event-item and event-equipmentslot\n"}).since("1.1.1");
            CompatibilityUtils.registerEventValue(PlayerArmorStandManipulateEvent.class, EquipmentSlot.class, PlayerArmorStandManipulateEvent::getSlot, 0);
            CompatibilityUtils.registerEventValue(PlayerArmorStandManipulateEvent.class, Entity.class, PlayerArmorStandManipulateEvent::getRightClicked, 0);
            CompatibilityUtils.registerEventValue(PlayerArmorStandManipulateEvent.class, LivingEntity.class, PlayerArmorStandManipulateEvent::getRightClicked, 0);
            CompatibilityUtils.registerEventValue(PlayerArmorStandManipulateEvent.class, ItemType.class, e -> new ItemType(e.getPlayerItem()), 1);
            CompatibilityUtils.registerEventValue(PlayerArmorStandManipulateEvent.class, ItemType.class, e -> new ItemType(e.getArmorStandItem()), 0);
            CompatibilityUtils.registerEventValue(PlayerArmorStandManipulateEvent.class, ArmorStandInteraction.class, EventUtils::getInteraction, 0);
        }
    }
}

